/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class China
extends DelegateCalendar {
    private static final China SSE_Calendar = new China(Market.SSE);

    private China(Market market) {
        ChinaSSECalendar delegate;
        switch (market) {
            case SSE: {
                delegate = new ChinaSSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static China getCalendar(Market market) {
        switch (market) {
            case SSE: {
                return SSE_Calendar;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class ChinaSSECalendar
    extends WesternCalendar {
        private ChinaSSECalendar() {
        }

        @Override
        public String getName() {
            return "Shanghai stock exchange";
        }

        @Override
        public final boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 3 && m == Month.JANUARY && y == 2005 || (d == 2 || d == 3) && m == Month.JANUARY && y == 2006 || d <= 3 && m == Month.JANUARY && y == 2007 || d == 31 && m == Month.DECEMBER && y == 2007 || d == 1 && m == Month.JANUARY && y == 2008 || d == 1 && m == Month.JANUARY && y == 2009 || d == 2 && m == Month.JANUARY && y == 2009 || d >= 19 && d <= 28 && m == Month.JANUARY && y == 2004 || d >= 7 && d <= 15 && m == Month.FEBRUARY && y == 2005 || (d >= 26 && m == Month.JANUARY || d <= 3 && m == Month.FEBRUARY) && y == 2006 || d >= 17 && d <= 25 && m == Month.FEBRUARY && y == 2007 || d >= 6 && d <= 12 && m == Month.FEBRUARY && y == 2008 || d >= 26 && d <= 30 && m == Month.JANUARY && y == 2009 || d == 4 && m == Month.APRIL && y == 2008 || d == 6 && m == Month.APRIL && y == 2009 || d >= 1 && d <= 7 && m == Month.MAY && y <= 2007 || d >= 1 && d <= 2 && m == Month.MAY && y == 2008 || d == 1 && m == Month.MAY && y == 2009 || d == 9 && m == Month.JUNE && y == 2008 || d >= 28 && d <= 29 && m == Month.MAY && y == 2009 || d == 15 && m == Month.SEPTEMBER && y == 2008 || d >= 1 && d <= 7 && m == Month.OCTOBER && y <= 2007 || d >= 29 && m == Month.SEPTEMBER && y == 2008 || d <= 3 && m == Month.OCTOBER && y == 2008) && (d < 1 || d > 8 || m != Month.OCTOBER || y != 2009);
        }
    }

    public static enum Market {
        SSE;

    }
}

