/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractCalendar
implements Calendar {
    protected static final String YEAR_OUT_OF_RANGE = "Year out of range";
    private final ArrayList<Date> addedHolidays = new ArrayList();

    protected AbstractCalendar() {
    }

    @Override
    public void addHoliday(Date d) {
        if (this.isBusinessDay(d)) {
            this.addedHolidays.add(d);
        }
    }

    @Override
    public void removeHoliday(Date d) {
        this.addedHolidays.remove(d);
    }

    protected boolean isAddedHoliday(Date date) {
        return this.addedHolidays.contains(date);
    }

    @Override
    public boolean isBusinessDay(Date date) {
        return !this.isAddedHoliday(date);
    }

    @Override
    public final Date adjust(Date d, BusinessDayConvention c) {
        if (d == null) {
            throw new NullPointerException();
        }
        if (c == BusinessDayConvention.UNADJUSTED) {
            return d;
        }
        Date d1 = d;
        if (c == BusinessDayConvention.FOLLOWING || c == BusinessDayConvention.MODIFIED_FOLLOWING) {
            while (this.isHoliday(d1)) {
                d1.increment();
            }
            if (c == BusinessDayConvention.MODIFIED_FOLLOWING && d1.getMonth() != d.getMonth()) {
                return this.adjust(d, BusinessDayConvention.PRECEDING);
            }
        } else if (c == BusinessDayConvention.PRECEDING || c == BusinessDayConvention.MODIFIED_PRECEDING) {
            while (this.isHoliday(d1)) {
                d1.decrement();
            }
            if (c == BusinessDayConvention.MODIFIED_PRECEDING && d1.getMonth() != d.getMonth()) {
                return this.adjust(d, BusinessDayConvention.FOLLOWING);
            }
        } else {
            throw new IllegalArgumentException("unknown business-day convention");
        }
        return d1;
    }

    @Override
    public final boolean isEndOfMonth(Date date) {
        return date.getMonth() != this.advance(date.getNextDay()).getMonth();
    }

    @Override
    public final Date getEndOfMonth(Date date) {
        return this.adjust(date.getEndOfMonth(), BusinessDayConvention.PRECEDING);
    }

    @Override
    public final boolean isHoliday(Date date) {
        return !this.isBusinessDay(date);
    }

    @Override
    public final Date advance(Date d) {
        return this.advance(d, 0, TimeUnit.DAYS);
    }

    @Override
    public final Date advance(Date d, int units, TimeUnit unit) {
        return this.advance(d, units, unit, BusinessDayConvention.FOLLOWING);
    }

    public final Date advance(Date d, int units, TimeUnit unit, BusinessDayConvention c) {
        return this.advance(d, units, unit, c, false);
    }

    @Override
    public final Date advance(Date date, int units, TimeUnit unit, BusinessDayConvention c, boolean endOfMonth) {
        if (date == null) {
            throw new NullPointerException();
        }
        Date d1 = DateFactory.getFactory().getDate(date.getDayOfMonth(), date.getMonthEnum(), date.getYear());
        int n = units;
        if (n == 0) {
            return this.adjust(d1, c);
        }
        if (unit == TimeUnit.DAYS) {
            if (n > 0) {
                while (n > 0) {
                    d1.increment();
                    while (this.isHoliday(d1)) {
                        d1.increment();
                    }
                    --n;
                }
            } else {
                while (n < 0) {
                    d1.decrement();
                    while (this.isHoliday(d1)) {
                        d1.decrement();
                    }
                    ++n;
                }
            }
            return d1;
        }
        if (unit == TimeUnit.WEEKS) {
            d1 = d1.adjust(new Period(n, unit));
            return this.adjust(d1, c);
        }
        d1 = d1.adjust(new Period(n, unit));
        if (endOfMonth && (unit == TimeUnit.MONTHS || unit == TimeUnit.YEARS) && this.isEndOfMonth(d1)) {
            return this.getEndOfMonth(d1);
        }
        return this.adjust(d1, c);
    }

    @Override
    public Date advance(Date d, Period p, BusinessDayConvention c) {
        return this.advance(d, p.length(), p.units(), c, false);
    }

    @Override
    public Date advance(Date d, Period p, BusinessDayConvention c, boolean endOfMonth) {
        return this.advance(d, p.length(), p.units(), c, endOfMonth);
    }

    @Override
    public long businessDaysBetween(Date from, Date to, boolean includeFirst, boolean includeLast) {
        int wd = 0;
        if (from.equals(to)) {
            if (this.isBusinessDay(from) && (includeFirst || includeLast)) {
                wd = 1;
            }
        } else {
            if (from.lt(to)) {
                Date d = from;
                while (d.le(to)) {
                    if (this.isBusinessDay(d)) {
                        ++wd;
                    }
                    d = d.getDateAfter(1);
                }
            } else if (from.gt(to)) {
                Date d = to;
                while (d.le(from)) {
                    if (this.isBusinessDay(d)) {
                        ++wd;
                    }
                    d = d.getDateAfter(1);
                }
            }
            if (this.isBusinessDay(from) && !includeFirst) {
                --wd;
            }
            if (this.isBusinessDay(to) && !includeLast) {
                --wd;
            }
            if (from.gt(to)) {
                wd = -wd;
            }
        }
        return wd;
    }

    @Override
    public List<Date> getHolidayList(Date from, Date to, boolean includeWeekEnds) {
        Date startDate;
        ArrayList<Date> holidays = new ArrayList<Date>();
        if (from.ge(to)) {
            String msg = MessageFormatter.format((String)"{} should be after {}", (Object)new Object[]{to, from});
            throw new IllegalStateException(msg);
        }
        Date d = startDate = from.getDateAfter(0);
        while (d.le(to)) {
            if (this.isHoliday(d) && (includeWeekEnds || !this.isWeekend(d.getWeekday()))) {
                holidays.add(d);
            }
            d = d.getDateAfter(1);
        }
        return holidays;
    }
}

