/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Array;
import org.jquantlib.math.Grid;
import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.functions.DoubleFunction;
import org.jquantlib.math.interpolations.CubicSplineInterpolation;
import org.jquantlib.math.interpolations.factories.NaturalCubicSpline;
import org.jquantlib.util.stdlibc.Std;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampledCurve {
    private static final Logger logger = LoggerFactory.getLogger(SampledCurve.class);
    private Array grid_;
    private Array values_;

    public SampledCurve(int gridSize) {
        this.grid_ = new Array(gridSize);
        this.values_ = new Array(gridSize);
    }

    public SampledCurve(Array grid) {
        this.grid_ = new Array(grid);
        this.values_ = new Array(grid.size());
    }

    public SampledCurve(SampledCurve that) {
        this.grid_ = new Array(that.grid_);
        this.values_ = new Array(that.values_);
    }

    public double valueAtCenter() {
        if (this.empty()) {
            throw new ArithmeticException("empty sampled curve");
        }
        int jmid = this.size() / 2;
        if (this.size() % 2 != 0) {
            return this.values_.at(jmid);
        }
        return (this.values_.at(jmid) + this.values_.at(jmid - 1)) / 2.0;
    }

    public double firstDerivativeAtCenter() {
        if (this.size() < 3) {
            throw new ArithmeticException("the size of the curve must be at least 3");
        }
        int jmid = this.size() / 2;
        if (this.size() % 2 != 0) {
            return (this.values_.at(jmid + 1) - this.values_.at(jmid - 1)) / (this.grid_.at(jmid + 1) - this.grid_.at(jmid - 1));
        }
        return (this.values_.at(jmid) - this.values_.at(jmid - 1)) / (this.grid_.at(jmid) - this.grid_.at(jmid - 1));
    }

    public double secondDerivativeAtCenter() {
        if (this.size() < 4) {
            throw new ArithmeticException("the size of the curve must be at least 4");
        }
        int jmid = this.size() / 2;
        if (this.size() % 2 != 0) {
            double deltaPlus = (this.values_.at(jmid + 1) - this.values_.at(jmid)) / (this.grid_.at(jmid + 1) - this.grid_.at(jmid));
            double deltaMinus = (this.values_.at(jmid) - this.values_.at(jmid - 1)) / (this.grid_.at(jmid) - this.grid_.at(jmid - 1));
            double dS = (this.grid_.at(jmid + 1) - this.grid_.at(jmid - 1)) / 2.0;
            return (deltaPlus - deltaMinus) / dS;
        }
        double deltaPlus = (this.values_.at(jmid + 1) - this.values_.at(jmid - 1)) / (this.grid_.at(jmid + 1) - this.grid_.at(jmid - 1));
        double deltaMinus = (this.values_.at(jmid) - this.values_.at(jmid - 2)) / (this.grid_.at(jmid) - this.grid_.at(jmid - 2));
        return (deltaPlus - deltaMinus) / (this.grid_.at(jmid) - this.grid_.at(jmid - 1));
    }

    public void regrid(Array newGrid) {
        double[] gridData = this.grid_.getData();
        double[] valueData = this.values_.getData();
        CubicSplineInterpolation priceSpline = new NaturalCubicSpline().interpolate(gridData, valueData);
        priceSpline.reload();
        Array newValues = new Array(newGrid.size());
        for (int i = 0; i < newGrid.size(); ++i) {
            newValues.set(i, priceSpline.evaluate(gridData[i], true));
        }
        this.values_.swap(newValues);
        this.grid_ = newGrid;
    }

    public void regrid(Array newGrid, UnaryFunctionDouble func) {
        Array transformedGrid = new Array(this.grid_.size());
        Std.transform(this.grid_, transformedGrid, func);
        double[] gridData = transformedGrid.getData();
        double[] valueData = this.values_.getData();
        CubicSplineInterpolation priceSpline = new NaturalCubicSpline().interpolate(gridData, valueData);
        priceSpline.reload();
        Array newValues = newGrid;
        Std.transform(newValues, newValues, func);
        for (int i = 0; i < newValues.size(); ++i) {
            newValues.set(i, priceSpline.evaluate(newValues.get(i), true));
        }
        this.values_.swap(newValues);
        this.grid_ = newGrid;
    }

    public Array grid() {
        return this.grid_;
    }

    public Array values() {
        return this.values_;
    }

    public double value(int i) {
        return this.values_.at(i);
    }

    public int size() {
        return this.grid_.size();
    }

    private boolean empty() {
        int sizeOfGrid = this.grid_.size();
        return sizeOfGrid == 0;
    }

    public void setValues(Array array) {
        this.values_ = new Array(array);
    }

    public void setLogGrid(double min, double max) {
        this.setGrid(Grid.BoundedLogGrid(min, max, this.size() - 1));
    }

    public <T extends DoubleFunction> void sample(T value) {
        for (int i = 0; i < this.grid_.size(); ++i) {
            this.values_.set(i, value.apply(this.grid_.at(i)));
        }
    }

    private void shiftGrid(double s) {
        this.grid_.operatorAdd(s);
    }

    private void scaleGrid(double s) {
        this.grid_.operatorMultiply(s);
    }

    private void setGrid(Array g) {
        this.grid_ = g;
    }
}

