/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import org.osgi.framework.BundlePermission;

final class BundlePermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3258407326846433079L;
    private final HashMap permissions = new HashMap();
    private boolean all_allowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof BundlePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BundlePermission bp = (BundlePermission)permission;
        String name = bp.getName();
        int newMask = bp.getMask();
        BundlePermissionCollection bundlePermissionCollection = this;
        synchronized (bundlePermissionCollection) {
            BundlePermission existing = (BundlePermission)this.permissions.get(name);
            if (existing != null) {
                int oldMask = existing.getMask();
                if (oldMask != newMask) {
                    this.permissions.put(name, new BundlePermission(name, oldMask | newMask));
                }
            } else {
                this.permissions.put(name, permission);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        int last;
        BundlePermission x;
        if (!(permission instanceof BundlePermission)) {
            return false;
        }
        BundlePermission bp = (BundlePermission)permission;
        String name = bp.getName();
        int desired = bp.getMask();
        int effective = 0;
        BundlePermissionCollection bundlePermissionCollection = this;
        synchronized (bundlePermissionCollection) {
            block11: {
                if (!this.all_allowed || (x = (BundlePermission)this.permissions.get("*")) == null || ((effective |= x.getMask()) & desired) != desired) break block11;
                return true;
            }
            x = (BundlePermission)this.permissions.get(name);
        }
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            name = String.valueOf(name.substring(0, last + 1)) + "*";
            BundlePermissionCollection bundlePermissionCollection2 = this;
            synchronized (bundlePermissionCollection2) {
                x = (BundlePermission)this.permissions.get(name);
            }
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return Collections.enumeration(this.permissions.values());
    }
}

