/*
 * Decompiled with CFR 0.152.
 */
package compat;

import devplugin.Plugin;
import java.io.File;

public final class IOCompat {
    public static String checkForRelativePath(String path) {
        if (path != null && (path.contains("\\") || path.contains("/"))) {
            File audioPath = new File(path);
            String[] homeParts = Plugin.getPluginManager().getTvBrowserSettings().getTvBrowserUserHome().replace("\\", "/").split("/");
            String[] pathParts = audioPath.getParent().replace("\\", "/").split("/");
            int i = 0;
            while (homeParts.length > i && pathParts.length > i && homeParts[i].equals(pathParts[i])) {
                ++i;
            }
            if (i > 0) {
                int j;
                StringBuilder relativeValue = new StringBuilder();
                if (i < homeParts.length) {
                    j = i;
                    while (j < homeParts.length) {
                        relativeValue.append("../");
                        ++j;
                    }
                } else {
                    relativeValue.append("./");
                }
                j = i;
                while (j < pathParts.length) {
                    relativeValue.append(pathParts[j]).append("/");
                    ++j;
                }
                relativeValue.append(audioPath.getName());
                return relativeValue.toString();
            }
        }
        return path;
    }

    public static String translateRelativePath(String path) {
        if (path != null && (path.startsWith("..") || path.startsWith("."))) {
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
            String[] pathParts = path.replace("\\", "/").split("/");
            String[] homeParts = Plugin.getPluginManager().getTvBrowserSettings().getTvBrowserUserHome().replace("\\", "/").split("/");
            int homePartsToUse = homeParts.length;
            int i = 0;
            while (i < pathParts.length && pathParts[i].equals("..")) {
                ++i;
                --homePartsToUse;
            }
            if (homePartsToUse >= 0 && pathParts.length > i) {
                StringBuilder pathToUse = new StringBuilder();
                int j = 0;
                while (j < homePartsToUse) {
                    pathToUse.append(homeParts[j]).append("/");
                    ++j;
                }
                j = i;
                while (j < pathParts.length) {
                    pathToUse.append(pathParts[j]).append("/");
                    ++j;
                }
                if (pathToUse.length() > 1 && pathToUse.toString().endsWith("/")) {
                    pathToUse.deleteCharAt(pathToUse.length() - 1);
                    path = pathToUse.toString();
                }
            }
        }
        return path;
    }
}

