/*
 * Decompiled with CFR 0.152.
 */
package util.ui.view;

import util.settings.PropertyManager;
import util.ui.view.ViewProperty;

public class SplitViewProperty
extends ViewProperty {
    private Property mDefaultValue;
    private Property mCachedValue;
    private PropertyManager mManager;
    private String mKey;

    public SplitViewProperty(PropertyManager manager, String key, boolean verticalSplit, boolean leftComponentIsFixed, int fixedComponentWidth) {
        super(manager, key);
        this.mManager = manager;
        this.mKey = key;
        this.mDefaultValue = new Property(verticalSplit, leftComponentIsFixed, fixedComponentWidth);
        this.mCachedValue = null;
    }

    private SplitViewProperty(PropertyManager manager, String key, Property prop) {
        this(manager, key, prop.isVerticalSplit(), prop.isLeftComponentFix(), prop.getFixComponentWidth());
    }

    public SplitViewProperty getDefault() {
        SplitViewProperty prop = new SplitViewProperty(this.mManager, this.mKey, this.mDefaultValue);
        prop.mCachedValue = new Property(this.mDefaultValue);
        return prop;
    }

    private String createPropertyString(Property prop) {
        return prop.isVerticalSplit() + ";" + prop.isLeftComponentFix() + ";" + prop.getFixComponentWidth();
    }

    private Property getPropertyFromString(String str) {
        if (str == null) {
            return this.mDefaultValue;
        }
        String[] s = str.split(";");
        if (s.length == 3) {
            try {
                boolean verticalSplit = "true".equals(s[0]);
                boolean leftComponent = "true".equals(s[1]);
                int width = Integer.parseInt(s[2]);
                return new Property(verticalSplit, leftComponent, width);
            }
            catch (NumberFormatException e) {
                return this.mDefaultValue;
            }
        }
        return this.mDefaultValue;
    }

    public void setVerticalSplit(boolean verticalSplit) {
        if (this.mCachedValue == null) {
            this.mCachedValue = new Property(this.mDefaultValue);
        }
        this.mCachedValue.setVerticalSplit(verticalSplit);
        this.setProperty(this.createPropertyString(this.mCachedValue));
    }

    public void setLeftComponentFixed(boolean fixed) {
        if (this.mCachedValue == null) {
            this.mCachedValue = new Property(this.mDefaultValue);
        }
        this.mCachedValue.setLeftComponentFix(fixed);
        this.setProperty(this.createPropertyString(this.mCachedValue));
    }

    public void setFixedComponentWidth(int width) {
        if (this.mCachedValue == null) {
            this.mCachedValue = new Property(this.mDefaultValue);
        }
        this.mCachedValue.setFixComponentWidth(width);
        this.setProperty(this.createPropertyString(this.mCachedValue));
    }

    public boolean getVerticalSplit() {
        if (this.mCachedValue == null) {
            this.mCachedValue = this.getPropertyFromString(this.getProperty());
        }
        return this.mCachedValue.isVerticalSplit();
    }

    public boolean getLeftComponentFixed() {
        if (this.mCachedValue == null) {
            this.mCachedValue = this.getPropertyFromString(this.getProperty());
        }
        return this.mCachedValue.isLeftComponentFix();
    }

    public int getFixedComponentWidth() {
        if (this.mCachedValue == null) {
            this.mCachedValue = this.getPropertyFromString(this.getProperty());
        }
        return this.mCachedValue.getFixComponentWidth();
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }

    public String toString() {
        if (this.mCachedValue == null) {
            return "not initialized";
        }
        return this.createPropertyString(this.mCachedValue);
    }

    private static class Property {
        private boolean mVerticalSplit;
        private boolean mLeftComponentIsFixed;
        private int mFixedComponentWidth;

        public Property(boolean verticalSplit, boolean leftComponentIsFixed, int width) {
            this.mVerticalSplit = verticalSplit;
            this.mLeftComponentIsFixed = leftComponentIsFixed;
            this.mFixedComponentWidth = width;
        }

        public Property(Property prop) {
            this(prop.mVerticalSplit, prop.mLeftComponentIsFixed, prop.mFixedComponentWidth);
        }

        public void setVerticalSplit(boolean v) {
            this.mVerticalSplit = v;
        }

        public boolean isVerticalSplit() {
            return this.mVerticalSplit;
        }

        public void setLeftComponentFix(boolean b) {
            this.mLeftComponentIsFixed = b;
        }

        public boolean isLeftComponentFix() {
            return this.mLeftComponentIsFixed;
        }

        public void setFixComponentWidth(int w) {
            this.mFixedComponentWidth = w;
        }

        public int getFixComponentWidth() {
            return this.mFixedComponentWidth;
        }
    }
}

