/*
 * Decompiled with CFR 0.152.
 */
package util.ui.progress;

import devplugin.ProgressMonitor;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressBarProgressMonitor
implements ProgressMonitor {
    private static final Logger mLog = Logger.getLogger(ProgressBarProgressMonitor.class.getName());
    private JProgressBar mProgressBar;
    private JLabel mLabel;

    public ProgressBarProgressMonitor(JProgressBar progressBar, JLabel label) {
        this.mProgressBar = progressBar;
        this.mLabel = label;
    }

    public ProgressBarProgressMonitor(JProgressBar progressBar) {
        this(progressBar, null);
    }

    @Override
    public void setMaximum(int maximum) {
        SwingUtilities.invokeLater(() -> this.mProgressBar.setMaximum(maximum));
    }

    @Override
    public void setValue(int value) {
        SwingUtilities.invokeLater(() -> this.mProgressBar.setValue(value));
    }

    @Override
    public void setMessage(String msg) {
        SwingUtilities.invokeLater(() -> {
            if (this.mLabel != null) {
                this.mLabel.setText(msg);
                mLog.info("Progress: " + msg);
            }
        });
    }
}

