/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.ui.settings.SettingsDialog;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;

public class DefaultProgramImportanceSelectionPanel
extends JPanel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(DefaultProgramImportanceSelectionPanel.class);
    private JComboBox<String> mProgramImportanceSelection;
    private JEditorPane mHelpLabel;

    private DefaultProgramImportanceSelectionPanel(byte importance, boolean showTitle, boolean withDefaultDialogBorder) {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu,default,5dlu,default,0dlu:grow"), (JPanel)this);
        if (withDefaultDialogBorder) {
            pb.border(Borders.DIALOG);
        }
        this.mProgramImportanceSelection = new JComboBox<String>(DefaultProgramImportanceSelectionPanel.getProgramImportanceNames(true));
        this.mProgramImportanceSelection.setSelectedIndex(this.getIndexForImportance(importance));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The selected importance is used to determinate the transparency of a program. It's calculated over all plugins as mean value. Lower importance leads to higher transparency. This works only if the plugins are allowed to set the transparency at <a href=\"#link\">program panel settings</a>."), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#programpanellook");
            }
        });
        if (showTitle) {
            pb.addSeparatorRowFull(false, DefaultProgramImportanceSelectionPanel.getTitle());
            pb.addLineGap();
        }
        pb.addLabelRow(false, LOCALIZER.msg("color", "Program importance:"), 2);
        pb.add(this.mProgramImportanceSelection, 4);
        pb.addRow("fill:0dlu:grow", false);
        pb.addRowFull("10dlu,default", (Component)this.mHelpLabel, 2);
    }

    public static DefaultProgramImportanceSelectionPanel createPanel(byte importance, boolean showTitle, boolean withDefaultDialogBorder) {
        return new DefaultProgramImportanceSelectionPanel(importance, showTitle, withDefaultDialogBorder);
    }

    public byte getSelectedImportance() {
        switch (this.mProgramImportanceSelection.getSelectedIndex()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 10;
            }
        }
        return -1;
    }

    private int getIndexForImportance(byte importance) {
        switch (importance) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public static String getTitle() {
        return LOCALIZER.msg("title", "Program transparency");
    }

    public static String[] getProgramImportanceNames(boolean withDefaultImportance) {
        if (withDefaultImportance) {
            return new String[]{LOCALIZER.msg("color.default", "Default importance"), LOCALIZER.msg("color.min", "Mininum importance"), LOCALIZER.msg("color.lowerMedium", "Lower medium importance"), LOCALIZER.msg("color.medium", "Medium importance"), LOCALIZER.msg("color.higherMedium", "Higher medium importance"), LOCALIZER.msg("color.max", "Maximum importance")};
        }
        return new String[]{LOCALIZER.msg("color.min", "Mininum importance"), LOCALIZER.msg("color.lowerMedium", "Lower medium importance"), LOCALIZER.msg("color.medium", "Medium importance"), LOCALIZER.msg("color.higherMedium", "Higher medium importance"), LOCALIZER.msg("color.max", "Maximum importance")};
    }
}

