/*
 * Decompiled with CFR 0.152.
 */
package util.i18n;

import util.i18n.Localizer;
import util.misc.StringPool;

public class PooledLocalizer
extends Localizer {
    private PooledLocalizer(Class<?> clazz) {
        super(clazz);
    }

    public static Localizer getLocalizerFor(Class<?> clazz) {
        Localizer localizer = PooledLocalizer.getCachedLocalizerFor(clazz);
        if (localizer == null) {
            localizer = new PooledLocalizer(clazz);
            PooledLocalizer.addLocalizerToCache(clazz, localizer);
        }
        return localizer;
    }

    private String pool(String msg) {
        return StringPool.getString(msg);
    }

    @Override
    public String msg(String key, String defaultMsg) {
        return this.pool(super.msg(key, defaultMsg));
    }

    @Override
    public String msg(String key, String defaultMsg, boolean warn) {
        return this.pool(super.msg(key, defaultMsg, warn));
    }

    @Override
    public String msg(String key, String defaultMsg, Object ... args) {
        return this.pool(super.msg(key, defaultMsg, args));
    }
}

