/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;

public class TrayOnTimeSettingsTab
implements SettingsTab {
    private JCheckBox mIsEnabled;
    private JCheckBox mShowTime;
    private JCheckBox mShowToolTip;
    private JCheckBox mShowProgress;
    private JRadioButton mShowInSubMenu;
    private JRadioButton mShowInTray;
    private static final Localizer LOCALIZER = TrayBaseSettingsTab.LOCALIZER;
    private JLabel mIconSeparator;
    private JLabel mSeparator1;
    private JLabel mSeparator2;
    private JLabel mDarkLabel;
    private JLabel mLightLabel;
    private static boolean mTrayIsEnabled = Settings.Tray.ENABLED.getBoolean();
    private JEditorPane mHelpLabel;
    private JEditorPane mInfo;
    private JEditorPane mTimeHelp;
    private JRadioButton mShowIconAndName;
    private JRadioButton mShowName;
    private JRadioButton mShowIcon;
    private JCheckBox mShowSortNumber;
    private ColorLabel mLightColorLb;
    private ColorLabel mDarkColorLb;
    private ColorButton mLight;
    private ColorButton mDark;
    private static TrayOnTimeSettingsTab mInstance;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        EnhancedPanelBuilder builder = new EnhancedPanelBuilder(new FormLayout("5dlu,12dlu,pref:grow,5dlu"));
        builder.border(Borders.DIALOG);
        this.mIsEnabled = new JCheckBox(LOCALIZER.msg("onTimeEnabled", "Show programs at..."), Settings.Tray.OnTime.ENABLED.getBoolean());
        ButtonGroup bg = new ButtonGroup();
        this.mShowInSubMenu = new JRadioButton(LOCALIZER.msg("inSubMenu", "in a sub menu"), Settings.Tray.OnTime.IN_SUB_MENU.getBoolean());
        this.mShowInTray = new JRadioButton(LOCALIZER.msg("inTray", "in the tray menu"), !this.mShowInSubMenu.isSelected());
        bg.add(this.mShowInSubMenu);
        bg.add(this.mShowInTray);
        this.mShowIconAndName = new JRadioButton(LOCALIZER.msg("showIconName", "Show channel icon and channel name"), Settings.Tray.OnTime.CONTAINS_NAME.getBoolean() && Settings.Tray.OnTime.CONTAINS_ICON.getBoolean());
        this.mShowIcon = new JRadioButton(LOCALIZER.msg("showIcon", "Show channel icon"), Settings.Tray.OnTime.CONTAINS_ICON.getBoolean() && !Settings.Tray.OnTime.CONTAINS_NAME.getBoolean());
        this.mShowName = new JRadioButton(LOCALIZER.msg("showName", "Show channel name"), !Settings.Tray.OnTime.CONTAINS_ICON.getBoolean() && Settings.Tray.OnTime.CONTAINS_NAME.getBoolean());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.mShowIconAndName);
        bg1.add(this.mShowIcon);
        bg1.add(this.mShowName);
        this.mShowSortNumber = new JCheckBox(LOCALIZER.msg("showChannelNumber", "Show sort number"), Settings.Tray.OnTime.SORT_NUMBER_SHOW.getBoolean());
        this.mShowTime = new JCheckBox(LOCALIZER.msg("showTime", "Show start time"), Settings.Tray.OnTime.CONTAINS_TIME.getBoolean());
        this.mShowToolTip = new JCheckBox(LOCALIZER.msg("showToolTip", "Show additional information of the program in a tool tip"), Settings.Tray.OnTime.CONTAINS_TOOL_TIP.getBoolean());
        this.mShowToolTip.setToolTipText(LOCALIZER.msg("toolTipTip", "Tool tips are small helper to something, like this one."));
        this.mShowProgress = new JCheckBox(LOCALIZER.msg("showProgress", "Show progress bar"), Settings.Tray.OnTime.PROGRESS_SHOW.getBoolean());
        this.mLightColorLb = new ColorLabel(Settings.Tray.OnTime.COLOR_PROGRESS_BACKGROUND_LIGHT.getColor());
        this.mLightColorLb.setStandardColor(Settings.Tray.OnTime.COLOR_PROGRESS_BACKGROUND_LIGHT.getDefaultColor());
        this.mDarkColorLb = new ColorLabel(Settings.Tray.OnTime.COLOR_PROGRESS_BACKGROUND_DARK.getColor());
        this.mDarkColorLb.setStandardColor(Settings.Tray.OnTime.COLOR_PROGRESS_BACKGROUND_DARK.getDefaultColor());
        this.mTimeHelp = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("helpTime", "If you want to change the times of this view, you simply have to change the times of the <a href=\"#link\">time buttons</a>."), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#timebuttons");
            }
        });
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#tray");
            }
        });
        this.mInfo = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("trayProgressInfo", "The progress bar simulates the progress of the program if the time would be reached."));
        this.mLight = new ColorButton(this.mLightColorLb);
        this.mDark = new ColorButton(this.mDarkColorLb);
        EnhancedPanelBuilder colors = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default,5dlu,default"), "2dlu");
        this.mDarkLabel = colors.addLabelRow(false, LOCALIZER.msg("progressLight", "Background color of the programs at..."), 1);
        colors.add(this.mLightColorLb, 3);
        colors.add(this.mLight, 5);
        this.mLightLabel = colors.addLabelRow(LOCALIZER.msg("progressDark", "Progress color of the programs at..."), 1);
        colors.add(this.mDarkColorLb, 3);
        colors.add(this.mDark, 5);
        JPanel c = (JPanel)builder.addSeparatorRowFull(false, LOCALIZER.msg("onTime", "Programs at..."));
        builder.addRow(this.mIsEnabled, 2, 2);
        builder.addRow(false, (Component)this.mShowInTray, 3);
        builder.addRow(false, (Component)this.mShowInSubMenu, 3);
        builder.addRow(this.mTimeHelp, 2, 2);
        JPanel c1 = (JPanel)builder.addParagraph(LOCALIZER.msg("iconNameSeparator", "Channel icons/channel name"));
        builder.addRow(this.mShowIconAndName, 2, 2);
        builder.addRow(false, (Component)this.mShowIcon, 2, 2);
        builder.addRow(false, (Component)this.mShowName, 2, 2);
        builder.addRow(this.mShowSortNumber, 2, 2);
        JPanel c2 = (JPanel)builder.addParagraph(LOCALIZER.msg("settings", "Settings"));
        builder.addRow(this.mShowTime, 2, 2);
        builder.addRow(false, (Component)this.mShowToolTip, 2, 2);
        builder.addRow(false, (Component)this.mShowProgress, 2, 2);
        builder.addRow("3dlu,default", (Component)colors.getPanel(), 3);
        builder.addRow(this.mInfo, 2, 2);
        builder.addRowFull("fill:pref:grow,default", (Component)this.mHelpLabel);
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.mIconSeparator = (JLabel)c1.getComponent(0);
        this.mSeparator2 = (JLabel)c2.getComponent(0);
        this.setEnabled(true);
        this.mIsEnabled.addActionListener(e -> this.setEnabled(false));
        this.mShowProgress.addActionListener(e -> {
            this.mLightColorLb.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
            this.mDarkColorLb.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
            this.mLight.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
            this.mDark.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
            this.mDarkLabel.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
            this.mLightLabel.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
            this.mInfo.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected());
        });
        return builder.getPanel();
    }

    private void setEnabled(boolean trayStateChange) {
        this.mHelpLabel.setVisible(!mTrayIsEnabled);
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
            this.mIsEnabled.setEnabled(mTrayIsEnabled);
        }
        TrayProgramsChannelsSettingsTab.setOnTimeIsEnabled(this.mIsEnabled.isSelected());
        this.mSeparator2.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInSubMenu.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInTray.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mIconSeparator.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mTimeHelp.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIconAndName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIcon.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowTime.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowToolTip.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowProgress.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mLightColorLb.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mDarkColorLb.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mLight.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mDark.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mDarkLabel.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mLightLabel.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mInfo.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mShowSortNumber.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
    }

    @Override
    public void saveSettings() {
        if (this.mIsEnabled != null) {
            Settings.Tray.OnTime.ENABLED.setBoolean(this.mIsEnabled.isSelected());
        }
        if (this.mShowInSubMenu != null) {
            Settings.Tray.OnTime.IN_SUB_MENU.setBoolean(this.mShowInSubMenu.isSelected());
        }
        if (this.mShowIconAndName != null && this.mShowName != null && this.mShowIcon != null) {
            Settings.Tray.OnTime.CONTAINS_NAME.setBoolean(this.mShowIconAndName.isSelected() || this.mShowName.isSelected());
            Settings.Tray.OnTime.CONTAINS_ICON.setBoolean(this.mShowIconAndName.isSelected() || this.mShowIcon.isSelected());
        }
        if (this.mShowTime != null) {
            Settings.Tray.OnTime.CONTAINS_TIME.setBoolean(this.mShowTime.isSelected());
        }
        if (this.mShowToolTip != null) {
            Settings.Tray.OnTime.CONTAINS_TOOL_TIP.setBoolean(this.mShowToolTip.isSelected());
        }
        if (this.mShowProgress != null) {
            Settings.Tray.OnTime.PROGRESS_SHOW.setBoolean(this.mShowProgress.isSelected());
        }
        if (this.mLightColorLb != null) {
            Settings.Tray.OnTime.COLOR_PROGRESS_BACKGROUND_LIGHT.setColor(this.mLightColorLb.getColor());
        }
        if (this.mDarkColorLb != null) {
            Settings.Tray.OnTime.COLOR_PROGRESS_BACKGROUND_DARK.setColor(this.mDarkColorLb.getColor());
        }
        if (this.mShowSortNumber != null) {
            Settings.Tray.OnTime.SORT_NUMBER_SHOW.setBoolean(this.mShowSortNumber.isSelected());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return TrayOnTimeSettingsTab.getName();
    }

    public static String getName() {
        return LOCALIZER.msg("onTime", "Programs at...");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }
}

