/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.CancelableSettingsTab;
import java.awt.Component;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;

public class ChannelIconAndNameSettingsTab
implements CancelableSettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ChannelIconAndNameSettingsTab.class);
    private JRadioButton mShowIconAndNameInProgramTable;
    private JRadioButton mShowOnlyIconInProgramTable;
    private JRadioButton mShowOnlyNameInProgramTable;
    private JRadioButton mShowIconInProgramPanelPlugins;
    private JRadioButton mShowIconInProgramPanelNever;
    private JRadioButton mShowIconAndNameInChannelLists;
    private JRadioButton mShowOnlyIconInChannelLists;
    private JRadioButton mShowOnlyNameInChannelLists;
    private JCheckBox mShowTooltipInProgramTable;
    private JCheckBox mShowSortNumberInProgramTable;
    private JCheckBox mShowSortNumberInChannelLists;
    private static int INDEX_ICONS_PROGRAM_PANEL = -1;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("5dlu, default:grow, default, 5dlu"));
        pb.border(Borders.DIALOG);
        pb.addSeparatorRowFull(false, LOCALIZER.msg("programTable", "Program table"));
        this.mShowIconAndNameInProgramTable = new JRadioButton(LOCALIZER.msg("showIconAndName", "Show channel icon and channel name"), Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.getBoolean() && Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.getBoolean());
        pb.addRow(this.mShowIconAndNameInProgramTable, 2, 2);
        this.mShowOnlyIconInProgramTable = new JRadioButton(LOCALIZER.msg("showOnlyIcon", "Show channel icon"), Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.getBoolean() && !Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.getBoolean());
        pb.addRow(false, (Component)this.mShowOnlyIconInProgramTable, 2, 2);
        this.mShowOnlyNameInProgramTable = new JRadioButton(LOCALIZER.msg("showOnlyName", "Show channel name"), Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.getBoolean() && !Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.getBoolean());
        pb.addRow(false, (Component)this.mShowOnlyNameInProgramTable, 2, 2);
        this.mShowSortNumberInProgramTable = new JCheckBox(LOCALIZER.msg("showChannelNumber", "Show sort number"), Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_TABLE.getBoolean());
        pb.addRow(this.mShowSortNumberInProgramTable, 2);
        this.mShowTooltipInProgramTable = new JCheckBox(LOCALIZER.msg("showToolTip", "Show large channel icons in tooltip"), Settings.IconAndNames.SHOW_CHANNEL_TOOLTIP_IN_PROGRAM_TABLE.getBoolean());
        pb.addRow(false, (Component)this.mShowTooltipInProgramTable, 2);
        this.mShowTooltipInProgramTable.setEnabled(!this.mShowOnlyNameInProgramTable.isSelected());
        this.mShowOnlyNameInProgramTable.addItemListener(e -> this.mShowTooltipInProgramTable.setEnabled(e.getStateChange() == 2));
        ButtonGroup programTable = new ButtonGroup();
        programTable.add(this.mShowIconAndNameInProgramTable);
        programTable.add(this.mShowOnlyIconInProgramTable);
        programTable.add(this.mShowOnlyNameInProgramTable);
        pb.addParagraph(LOCALIZER.msg("programPanels", "Program panels"));
        this.mShowIconInProgramPanelPlugins = new JRadioButton(LOCALIZER.msg("showLogoPlugins", "Plugins decide showing of channel logos"), Settings.IconAndNames.SHOW_LOGO_FOR_PROGRAM_PANEL.getInt() == 0);
        pb.addRow(this.mShowIconInProgramPanelPlugins, 2, 2);
        this.mShowIconInProgramPanelNever = new JRadioButton(LOCALIZER.msg("showLogoNever", "Channel logos are never shown"), Settings.IconAndNames.SHOW_LOGO_FOR_PROGRAM_PANEL.getInt() == 1);
        pb.addRow(false, (Component)this.mShowIconInProgramPanelNever, 2, 2);
        if (INDEX_ICONS_PROGRAM_PANEL == -1) {
            INDEX_ICONS_PROGRAM_PANEL = Settings.IconAndNames.SHOW_LOGO_FOR_PROGRAM_PANEL.getInt();
        }
        ButtonGroup programPanels = new ButtonGroup();
        programPanels.add(this.mShowIconInProgramPanelPlugins);
        programPanels.add(this.mShowIconInProgramPanelNever);
        pb.addParagraph(LOCALIZER.msg("channelLists", "Channel lists"), 1, 4);
        this.mShowIconAndNameInChannelLists = new JRadioButton(LOCALIZER.msg("showIconAndName", "Show channel icon and channel name"), Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean() && Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.getBoolean());
        pb.addRow(this.mShowIconAndNameInChannelLists, 2, 2);
        this.mShowOnlyIconInChannelLists = new JRadioButton(LOCALIZER.msg("showOnlyIcon", "Show channel icon"), Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean() && !Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.getBoolean());
        pb.addRow(false, (Component)this.mShowOnlyIconInChannelLists, 2, 2);
        this.mShowOnlyNameInChannelLists = new JRadioButton(LOCALIZER.msg("showOnlyName", "Show channel name"), Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.getBoolean() && !Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean());
        pb.addRow(false, (Component)this.mShowOnlyNameInChannelLists, 2, 2);
        this.mShowSortNumberInChannelLists = new JCheckBox(LOCALIZER.msg("showChannelNumber", "Show sort number"), Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_LISTS.getBoolean());
        pb.addRow(this.mShowSortNumberInChannelLists, 2, 2);
        ButtonGroup channelLists = new ButtonGroup();
        channelLists.add(this.mShowIconAndNameInChannelLists);
        channelLists.add(this.mShowOnlyIconInChannelLists);
        channelLists.add(this.mShowOnlyNameInChannelLists);
        ItemListener pluginProgramPanelLogoListener = e -> {
            if (e.getStateChange() == 1) {
                Settings.setRestartInfo(ChannelIconAndNameSettingsTab.class.getCanonicalName(), this.mShowIconInProgramPanelPlugins.equals(e.getItem()) && INDEX_ICONS_PROGRAM_PANEL != 0 || this.mShowIconInProgramPanelNever.equals(e.getItem()) && INDEX_ICONS_PROGRAM_PANEL != 1);
            }
        };
        this.mShowIconInProgramPanelNever.addItemListener(pluginProgramPanelLogoListener);
        this.mShowIconInProgramPanelPlugins.addItemListener(pluginProgramPanelLogoListener);
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.setBoolean(this.mShowIconAndNameInProgramTable.isSelected() || this.mShowOnlyIconInProgramTable.isSelected());
        Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.setBoolean(this.mShowIconAndNameInProgramTable.isSelected() || this.mShowOnlyNameInProgramTable.isSelected());
        if (this.mShowIconInProgramPanelPlugins.isSelected()) {
            Settings.IconAndNames.SHOW_LOGO_FOR_PROGRAM_PANEL.setInt(0);
        } else {
            Settings.IconAndNames.SHOW_LOGO_FOR_PROGRAM_PANEL.setInt(1);
        }
        Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.setBoolean(this.mShowIconAndNameInChannelLists.isSelected() || this.mShowOnlyIconInChannelLists.isSelected());
        Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.setBoolean(this.mShowIconAndNameInChannelLists.isSelected() || this.mShowOnlyNameInChannelLists.isSelected());
        Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_TABLE.setBoolean(this.mShowSortNumberInProgramTable.isSelected());
        Settings.IconAndNames.SHOW_CHANNEL_TOOLTIP_IN_PROGRAM_TABLE.setBoolean(this.mShowTooltipInProgramTable.isSelected());
        Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_LISTS.setBoolean(this.mShowSortNumberInChannelLists.isSelected());
    }

    @Override
    public void cancel() {
        Settings.setRestartInfo(ChannelIconAndNameSettingsTab.class.getCanonicalName(), INDEX_ICONS_PROGRAM_PANEL != Settings.IconAndNames.SHOW_LOGO_FOR_PROGRAM_PANEL.getInt());
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Channel icons and names");
    }
}

