/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ChannelFilter;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableModelListener;
import util.io.IOUtilities;
import util.program.ProgramUtilities;
import util.ui.ProgramPanel;

public class DefaultProgramTableModel
implements ProgramTableModel,
ChangeListener {
    private static final int MAXIMUM_WAIT_TIME_FOR_THREAD_POOL_IN_SECONDS = 30;
    private int mTomorrowLatestTime;
    private int mTodayEarliestTime;
    private ArrayList<ProgramTableModelListener> mListenerList;
    private Channel[] mChannelArr;
    private Channel[] mShownChannelArr;
    private Date mMainDay;
    private ArrayList<ProgramPanel>[] mProgramColumn;
    private ArrayList<ProgramPanel>[] mShownProgramColumn;
    private int mLastTimerMinutesAfterMidnight;
    private Timer mTimer;
    private ProgramFilter mProgramFilter = null;
    private HashMap<Channel, DateRange> mDateRangeForChannel = new HashMap();
    private int[] mOnAirRows;
    private ChannelFilter mChannelFilter = null;

    public DefaultProgramTableModel(Channel[] channelArr, int todayEarliestTime, int tomorrowLatestTime) {
        this.mListenerList = new ArrayList();
        this.mTodayEarliestTime = todayEarliestTime;
        this.mTomorrowLatestTime = tomorrowLatestTime;
        this.mMainDay = new Date();
        this.setChannels(channelArr);
        this.mTimer = new Timer(10000, e -> this.handleTimerEvent());
        this.mTimer.start();
    }

    private DateRange getDateRangeForChannel(Channel ch) {
        int channelTime = ch.getTimeZone().getRawOffset() / 60000;
        if (ch.getTimeZone().useDaylightTime()) {
            channelTime += 60;
        }
        int localTime = TimeZone.getDefault().getRawOffset() / 60000;
        if (ch.getTimeZone().useDaylightTime()) {
            localTime += 60;
        }
        int timeDiff = channelTime - localTime;
        int startTimeForChannelLocale = this.mTodayEarliestTime + timeDiff;
        int endTimeForChannelLocale = this.mTomorrowLatestTime + 59 + timeDiff + 1440;
        int fromDate = startTimeForChannelLocale >= 0 ? startTimeForChannelLocale / 24 / 60 : startTimeForChannelLocale / 24 / 60 - 1;
        int toDate = endTimeForChannelLocale > 0 ? endTimeForChannelLocale / 24 / 60 + 1 : endTimeForChannelLocale / 24 / 60 - 1 + 1;
        if (!TvDataBase.getInstance().isDayProgramAvailable(this.mMainDay.addDays(fromDate), ch)) {
            ++fromDate;
        }
        return new DateRange(fromDate, toDate - fromDate);
    }

    public void setTimeRange(int todayEarliestTime, int tomorrowLatestTime) {
        this.mTodayEarliestTime = todayEarliestTime;
        this.mTomorrowLatestTime = tomorrowLatestTime;
        this.fireTableDataChanged(null);
    }

    private void updateDateRange() {
        this.mDateRangeForChannel.clear();
        for (Channel channel : this.mChannelArr) {
            DateRange dateRange = this.getDateRangeForChannel(channel);
            this.mDateRangeForChannel.put(channel, dateRange);
        }
    }

    public void setChannels(Channel[] channelArr) {
        if (channelArr == null) {
            throw new NullPointerException("shownChannelArr is null!");
        }
        this.checkThread();
        this.mChannelArr = channelArr;
        int joinedChannelCount = 0;
        for (Channel ch : this.mChannelArr) {
            if (ch.getJointChannel() == null) continue;
            ++joinedChannelCount;
        }
        this.mProgramColumn = new ArrayList[this.mChannelArr.length - joinedChannelCount];
        for (int i = 0; i < this.mProgramColumn.length; ++i) {
            this.mProgramColumn[i] = new ArrayList();
        }
        this.updateDateRange();
        this.updateTableContent();
    }

    @Override
    public void setProgramFilter(ProgramFilter filter) {
        this.mProgramFilter = filter;
        this.updateTableContent();
        this.fireTableDataChanged(null);
    }

    @Override
    public void setChannelFilter(ChannelFilter channelFilter) {
        this.mChannelFilter = channelFilter;
        this.updateTableContent();
        this.fireTableDataChanged(null);
    }

    public ProgramFilter getProgramFilter() {
        FilterList filterList;
        ProgramFilter result = this.mProgramFilter;
        if (result == null && (result = (filterList = FilterList.getInstance()).getFilterByName(Settings.Window.FILTER_LAST_USED.getString())) == null) {
            result = FilterManagerImpl.getInstance().getDefaultFilter();
        }
        return result;
    }

    public ChannelFilter getChannelFilter() {
        return this.mChannelFilter;
    }

    private static int compareDateTime(Date d1, int m1, Date d2, int m2) {
        if (d1.compareTo(d2) < 0) {
            return -1;
        }
        if (d1.compareTo(d2) > 0) {
            return 1;
        }
        if (m1 < m2) {
            return -1;
        }
        if (m1 > m2) {
            return 1;
        }
        return 0;
    }

    private void addChannelDayProgram(int col, ChannelDayProgram[] cdpArr, ChannelDayProgram[] jointChannelProgArr, Date fromDate, int fromMinutes, Date toDate, int toMinutes) {
        if (cdpArr == null) {
            return;
        }
        ArrayList programIteratorArray = new ArrayList();
        if (jointChannelProgArr == null) {
            jointChannelProgArr = new ChannelDayProgram[]{};
        }
        int minLength = Math.min(cdpArr.length, jointChannelProgArr.length);
        for (int i = 0; i < minLength; ++i) {
            int n;
            ArrayList<Program> tempList = new ArrayList<Program>();
            if (cdpArr[i] != null) {
                for (n = 0; n < cdpArr[i].getProgramCount(); ++n) {
                    tempList.add(cdpArr[i].getProgramAt(n));
                }
            }
            if (jointChannelProgArr[i] != null) {
                for (n = 0; n < jointChannelProgArr[i].getProgramCount(); ++n) {
                    tempList.add(jointChannelProgArr[i].getProgramAt(n));
                }
            }
            Collections.sort(tempList, ProgramUtilities.getProgramComparator());
            programIteratorArray.add(tempList.iterator());
        }
        ChannelDayProgram[] longerDayRange = cdpArr;
        if (jointChannelProgArr.length > cdpArr.length) {
            longerDayRange = jointChannelProgArr;
        }
        for (int i = minLength; i < longerDayRange.length; ++i) {
            if (longerDayRange[i] == null) continue;
            programIteratorArray.add(longerDayRange[i].getPrograms());
        }
        for (Iterator iterator : programIteratorArray) {
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                ProgramPanel panel;
                Program prog = (Program)iterator.next();
                int progTime = prog.getStartTime();
                Date progDate = prog.getDate();
                if (DefaultProgramTableModel.compareDateTime(progDate, progTime, toDate, toMinutes) > 0) continue;
                if (DefaultProgramTableModel.compareDateTime(progDate, progTime, fromDate, fromMinutes) >= 0) {
                    if (!this.filterAccepts(prog)) continue;
                    panel = new ProgramPanel(prog);
                    this.mProgramColumn[col].add(panel);
                    continue;
                }
                if (!this.mProgramColumn[col].isEmpty() || DefaultProgramTableModel.compareDateTime(progDate, progTime + prog.getLength(), fromDate, fromMinutes) <= 0 || !this.filterAccepts(prog)) continue;
                panel = new ProgramPanel(prog);
                this.mProgramColumn[col].add(panel);
            }
        }
    }

    private boolean filterAccepts(Program program) {
        return !(this.mChannelFilter != null && !this.mChannelFilter.accept(program) || this.mProgramFilter != null && !this.mProgramFilter.accept(program));
    }

    public void setDate(Date date, ProgressMonitor monitor, Runnable callback) {
        this.mMainDay = date;
        this.updateDateRange();
        this.updateTableContent(monitor, callback);
    }

    @Override
    public Date getDate() {
        return this.mMainDay;
    }

    public void updateTableContent() {
        this.updateTableContent(null, null);
    }

    private synchronized void updateTableContent(final ProgressMonitor monitor, Runnable callback) {
        if (this.mProgramFilter == null || MainFrame.isStarting()) {
            this.mShownProgramColumn = (ArrayList[])this.mProgramColumn.clone();
            this.mShownChannelArr = (Channel[])this.mChannelArr.clone();
            return;
        }
        this.checkThread();
        this.mOnAirRows = null;
        this.deregisterFromPrograms(this.mProgramColumn);
        TvDataBase db = TvDataBase.getInstance();
        if (monitor != null) {
            monitor.setMaximum(this.mProgramColumn.length - 1);
            monitor.setValue(0);
        }
        final Date nextDay = this.mMainDay.addDays(1);
        int jointChannelCount = 0;
        ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 3));
        for (int i = 0; i < this.mChannelArr.length; ++i) {
            this.mProgramColumn[i - jointChannelCount].clear();
            DateRange dateRange = this.mDateRangeForChannel.get(this.mChannelArr[i]);
            final ChannelDayProgram[] cdp = new ChannelDayProgram[dateRange.getCount()];
            for (int d = 0; d < cdp.length; ++d) {
                cdp[d] = db.getDayProgram(this.mMainDay.addDays(dateRange.getBegin() + d), this.mChannelArr[i]);
            }
            ChannelDayProgram[] jointChannelDayProgram = null;
            Channel jointChannel = this.mChannelArr[i].getJointChannel();
            if (jointChannel != null) {
                ++jointChannelCount;
                ++i;
                dateRange = this.mDateRangeForChannel.get(jointChannel);
                jointChannelDayProgram = new ChannelDayProgram[dateRange.getCount()];
                for (int d = 0; d < jointChannelDayProgram.length; ++d) {
                    jointChannelDayProgram[d] = db.getDayProgram(this.mMainDay.addDays(dateRange.getBegin() + d), jointChannel);
                }
            }
            final int finalI = i;
            final int index = i - jointChannelCount;
            final ChannelDayProgram[] use = jointChannelDayProgram;
            threadPool.execute(new Thread("ADD CHANNEL DAY PROGRAM TO PROGRAM TABLE MODEL THREAD"){

                @Override
                public void run() {
                    DefaultProgramTableModel.this.addChannelDayProgram(index, cdp, use, DefaultProgramTableModel.this.mMainDay, DefaultProgramTableModel.this.mTodayEarliestTime, nextDay, DefaultProgramTableModel.this.mTomorrowLatestTime);
                    if (monitor != null) {
                        monitor.setValue(finalI);
                    }
                }
            });
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        boolean showEmptyColumns = this.mProgramFilter instanceof ShowAllFilter && this.mChannelFilter == null;
        ArrayList<ArrayList<ProgramPanel>> newShownColumns = new ArrayList<ArrayList<ProgramPanel>>();
        ArrayList<Channel> newShownChannels = new ArrayList<Channel>();
        jointChannelCount = 0;
        for (int i = 0; i < this.mProgramColumn.length; ++i) {
            if ((showEmptyColumns || this.mProgramColumn[i].size() > 0) && this.mChannelArr[i + jointChannelCount].getBaseChannel() == null) {
                newShownColumns.add(this.mProgramColumn[i]);
                newShownChannels.add(this.mChannelArr[i + jointChannelCount]);
            }
            if (this.mChannelArr[i + jointChannelCount].getJointChannel() == null) continue;
            ++jointChannelCount;
        }
        this.mShownProgramColumn = new ArrayList[newShownColumns.size()];
        this.mShownChannelArr = new Channel[newShownChannels.size()];
        newShownColumns.toArray(this.mShownProgramColumn);
        newShownChannels.toArray(this.mShownChannelArr);
        this.handleTimerEvent();
        this.registerAtPrograms(this.mProgramColumn);
        this.fireTableDataChanged(callback);
    }

    @Override
    public void addProgramTableModelListener(ProgramTableModelListener listener) {
        this.mListenerList.add(listener);
    }

    @Override
    public Channel[] getShownChannels() {
        this.checkThread();
        return this.mShownChannelArr;
    }

    public int getAvailableChannelCount() {
        this.checkThread();
        return this.mChannelArr.length;
    }

    @Override
    public int getColumnCount() {
        return Math.min(this.mShownChannelArr.length, this.mProgramColumn.length);
    }

    @Override
    public int getRowCount(int col) {
        return this.mShownProgramColumn[col].size();
    }

    @Override
    public ProgramPanel getProgramPanel(int col, int row) {
        ArrayList<ProgramPanel> list = this.mShownProgramColumn[col];
        if (list.size() <= row) {
            return null;
        }
        return list.get(row);
    }

    private void deregisterFromPrograms(ArrayList<ProgramPanel>[] columns) {
        for (ArrayList<ProgramPanel> list : columns) {
            for (ProgramPanel panel : list) {
                Program prog = panel.getProgram();
                prog.removeChangeListener(this);
            }
        }
    }

    private void registerAtPrograms(ArrayList<ProgramPanel>[] columns) {
        for (ArrayList<ProgramPanel> list : columns) {
            for (ProgramPanel panel : list) {
                Program prog = panel.getProgram();
                prog.addChangeListener(this);
            }
        }
    }

    protected void fireTableDataChanged(Runnable callback) {
        for (int i = 0; i < this.mListenerList.size(); ++i) {
            ProgramTableModelListener lst = this.mListenerList.get(i);
            lst.tableDataChanged(callback);
        }
    }

    protected void fireTableCellUpdated(int col, int row) {
        for (int i = 0; i < this.mListenerList.size(); ++i) {
            ProgramTableModelListener lst = this.mListenerList.get(i);
            lst.tableCellUpdated(col, row);
        }
    }

    protected int getColumnOfChannel(Channel channel) {
        channel = Channel.getChannelForChannel(channel);
        this.checkThread();
        for (int col = 0; col < this.mShownChannelArr.length; ++col) {
            if (!channel.equals(this.mShownChannelArr[col])) continue;
            return col;
        }
        return -1;
    }

    public boolean contains(Program p) throws Exception {
        this.checkThread();
        for (int i = 0; i < this.mShownChannelArr.length; ++i) {
            if (!p.getChannel().equals(this.mShownChannelArr[i])) continue;
            for (ProgramPanel panel : this.mShownProgramColumn[i]) {
                if (!panel.getProgram().equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private void handleTimerEvent() {
        this.checkThread();
        int minutesAfterMidnight = IOUtilities.getMinutesAfterMidnight();
        if (minutesAfterMidnight == this.mLastTimerMinutesAfterMidnight) {
            return;
        }
        this.mLastTimerMinutesAfterMidnight = minutesAfterMidnight;
        ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 3));
        if (this.mOnAirRows == null) {
            int columnCount = this.getColumnCount();
            this.mOnAirRows = new int[columnCount];
            Arrays.fill(this.mOnAirRows, -1);
            for (int col1 = 0; col1 < columnCount; ++col1) {
                final int col = col1;
                int rowCount = this.getRowCount(col);
                int row1 = 0;
                while (row1 < rowCount) {
                    final int row = row1++;
                    threadPool.execute(new Thread("FORCE REPAINT ON AIR PROGRAMS THREAD NEW"){

                        @Override
                        public void run() {
                            ProgramPanel panel = DefaultProgramTableModel.this.getProgramPanel(col, row);
                            if (panel.getProgram().isOnAir()) {
                                DefaultProgramTableModel.this.mOnAirRows[col] = row;
                                DefaultProgramTableModel.this.fireTableCellUpdated(col, row);
                            }
                        }
                    });
                }
            }
        } else {
            int col1 = 0;
            while (col1 < this.mOnAirRows.length) {
                final int col = col1++;
                threadPool.execute(new Thread("FORCE REPAINT ON AIR PROGRAMS THREAD CURRENT"){

                    @Override
                    public void run() {
                        if (DefaultProgramTableModel.this.mOnAirRows[col] != -1) {
                            ProgramPanel panel = DefaultProgramTableModel.this.getProgramPanel(col, DefaultProgramTableModel.this.mOnAirRows[col]);
                            if (panel.getProgram().isOnAir()) {
                                DefaultProgramTableModel.this.fireTableCellUpdated(col, DefaultProgramTableModel.this.mOnAirRows[col]);
                            } else if (panel.getProgram().isExpired()) {
                                DefaultProgramTableModel.this.fireTableCellUpdated(col, DefaultProgramTableModel.this.mOnAirRows[col]);
                                panel = DefaultProgramTableModel.this.getProgramPanel(col, DefaultProgramTableModel.this.mOnAirRows[col] + 1);
                                if (panel == null) {
                                    DefaultProgramTableModel.this.mOnAirRows[col] = -1;
                                } else {
                                    DefaultProgramTableModel.this.mOnAirRows[col] = DefaultProgramTableModel.this.mOnAirRows[col] + 1;
                                    DefaultProgramTableModel.this.fireTableCellUpdated(col, DefaultProgramTableModel.this.mOnAirRows[col]);
                                }
                            }
                        }
                    }
                });
            }
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Program program = (Program)evt.getSource();
        SwingUtilities.invokeLater(() -> this.fireProgramHasChanged(program));
    }

    protected void fireProgramHasChanged(Program program) {
        int col = this.getColumnOfChannel(program.getChannel());
        if (col == -1) {
            return;
        }
        int rowCount = this.getRowCount(col);
        for (int row = 0; row < rowCount; ++row) {
            ProgramPanel panel = this.getProgramPanel(col, row);
            if (program != panel.getProgram()) continue;
            if (panel.pictureStateChanged()) {
                this.updateTableContent();
            } else {
                panel.programHasChanged();
                this.fireTableCellUpdated(col, row);
            }
            return;
        }
    }

    private void checkThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The table model must be used in the Swing event thread (use SwingUtilities.invokeLater())");
        }
    }

    private static class DateRange {
        private int mCnt;
        private int mBegin;

        public DateRange(int begin, int cnt) {
            this.mBegin = begin;
            this.mCnt = cnt;
        }

        public int getBegin() {
            return this.mBegin;
        }

        public int getCount() {
            return this.mCnt;
        }
    }
}

