/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import devplugin.ProgressMonitor;
import devplugin.ProgressMonitorExtended;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public class StatusBar
extends JPanel {
    private JProgressBar mProgressBar;
    private JLabel mInfoLabel;

    public StatusBar(KeyListener keyListener) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(1, 0));
        if (!UiUtilities.isNimbusLookAndFeel() && !UiUtilities.isGTKLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        }
        this.setPreferredSize(new Dimension(0, 22));
        this.mInfoLabel = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getHeaderImage() != null && Persona.getInstance().getTextColor() != null && Persona.getInstance().getShadowColor() != null) {
                    int baseLine = this.getBaseline(0, this.getHeight()) - 1;
                    if (!Persona.getInstance().getShadowColor().equals(Persona.getInstance().getTextColor())) {
                        g.setColor(Persona.getInstance().getShadowColor());
                        g.drawString(this.getText(), this.getIconTextGap() + 1, baseLine + 1);
                        g.drawString(this.getText(), this.getIconTextGap() + 2, baseLine + 2);
                    }
                    g.setColor(Persona.getInstance().getTextColor());
                    g.drawString(this.getText(), this.getIconTextGap(), baseLine);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        this.mInfoLabel.addKeyListener(keyListener);
        this.mProgressBar = new JProgressBar();
        this.mProgressBar.setVisible(false);
        this.mProgressBar.addKeyListener(keyListener);
        this.mProgressBar.setPreferredSize(new Dimension(150, 10));
        this.updatePersona();
        this.add((Component)this.mInfoLabel, "Center");
        this.add((Component)this.mProgressBar, "East");
    }

    public JProgressBar getProgressBar() {
        return this.mProgressBar;
    }

    public JLabel getLabel() {
        return this.mInfoLabel;
    }

    public ProgressMonitor createProgressMonitor() {
        return new ProgressMonitorExtended(){

            @Override
            public void setMaximum(int maximum) {
                StatusBar.this.mProgressBar.setMaximum(maximum);
            }

            @Override
            public void setValue(int value) {
                StatusBar.this.mProgressBar.setValue(value);
            }

            @Override
            public void setIndeterminate(boolean newValue) {
                StatusBar.this.mProgressBar.setIndeterminate(newValue);
            }

            @Override
            public void setMessage(String msg) {
                StatusBar.this.mInfoLabel.setText(msg);
            }

            @Override
            public void setVisible(boolean newValue) {
                StatusBar.this.mProgressBar.setVisible(newValue);
            }
        };
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() == null) {
            this.mInfoLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mProgressBar.getBackground().darker().darker()), BorderFactory.createMatteBorder(0, 0, 1, 1, this.mProgressBar.getBackground().brighter())), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
            this.mProgressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mProgressBar.getBackground().darker().darker()), BorderFactory.createMatteBorder(0, 0, 1, 1, this.mProgressBar.getBackground().brighter())), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mProgressBar.getBackground().darker().darker()), BorderFactory.createMatteBorder(0, 0, 1, 1, this.mProgressBar.getBackground().brighter().brighter())))));
        } else {
            this.mInfoLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.mProgressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.mProgressBar.getBackground().darker().darker()), BorderFactory.createMatteBorder(0, 0, 1, 1, this.mProgressBar.getBackground().brighter().brighter()))));
        }
    }
}

