/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import util.i18n.Localizer;

public class PeriodItem {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PeriodItem.class);
    private int mDays;
    private static final PeriodItem[] PERIOD_ARR = new PeriodItem[]{new PeriodItem(0), new PeriodItem(1), new PeriodItem(2), new PeriodItem(3), new PeriodItem(7), new PeriodItem(14), new PeriodItem(21), new PeriodItem(28)};

    public PeriodItem(int days) {
        this.mDays = days;
    }

    public String toString() {
        switch (this.mDays) {
            case 0: {
                return Localizer.getLocalization("i18n_today");
            }
            case 1: {
                return mLocalizer.msg("period.1", "Up to tomorrow");
            }
            case 2: {
                return mLocalizer.msg("period.2", "Next 2 days");
            }
            case 3: {
                return mLocalizer.msg("period.3", "Next 3 days");
            }
            case 7: {
                return mLocalizer.msg("period.7", "Next week");
            }
            case 14: {
                return mLocalizer.msg("period.14", "Next 2 week");
            }
            case 21: {
                return mLocalizer.msg("period.21", "Next 3 week");
            }
            case 28: {
                return mLocalizer.msg("period.1000", "All");
            }
        }
        return "---";
    }

    public int getDays() {
        return this.mDays;
    }

    public int hashCode() {
        return this.mDays;
    }

    public boolean equals(Object o) {
        if (o instanceof PeriodItem) {
            PeriodItem p = (PeriodItem)o;
            return p.getDays() == this.mDays;
        }
        return false;
    }

    public static final PeriodItem[] getPeriodItems() {
        return (PeriodItem[])PERIOD_ARR.clone();
    }
}

