/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import devplugin.ProgramFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.filter.dlgs.FilterNode;
import tvbrowser.ui.filter.dlgs.FilterTreeModel;
import tvbrowser.ui.filter.dlgs.SelectFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.OverlayListener;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class FilterTree
extends JTree
implements DragGestureListener,
DropTargetListener {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(FilterTree.class);
    private FilterNode mTransferNode;
    private Rectangle2D mCueLine = new Rectangle2D.Float();
    private FilterNode mRootNode;
    private FilterNode mTargetNode;
    private int mTarget;
    private long mDragOverStart;
    private boolean mExpandListenerIsEnabled;
    private static final DataFlavor FILTER_FLAVOR = new DataFlavor(TreePath.class, "FilterNodeExport");

    FilterTree() {
        this.init();
    }

    @Override
    public void updateUI() {
        this.setUI(new FilterTreeUI());
        this.invalidate();
    }

    private void init() {
        this.setModel(FilterList.getInstance().getFilterTreeModel());
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.mRootNode = (FilterNode)FilterList.getInstance().getFilterTreeModel().getRoot();
        FilterTreeCellRenderer renderer = new FilterTreeCellRenderer();
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.mExpandListenerIsEnabled = false;
        this.expand(this.mRootNode);
        this.mExpandListenerIsEnabled = true;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FilterNode node = FilterTree.this.getSelectedFilterNode();
                if (e.getKeyCode() == 127) {
                    SelectFilterDlg.getInstance().deleteSelectedItem(node);
                } else if (e.getKeyCode() == 525) {
                    if (FilterTree.this.getSelectionPath() != null) {
                        Rectangle pathBounds = FilterTree.this.getRowBounds(FilterTree.this.getRowForPath(FilterTree.this.getSelectionPath()));
                        FilterTree.this.showContextMenu(new Point(pathBounds.x + pathBounds.width - 10, pathBounds.y + pathBounds.height - 5));
                    }
                } else if (e.getKeyCode() == 113) {
                    SelectFilterDlg.getInstance().editSelectedFilter(node);
                }
            }
        });
        this.mExpandListenerIsEnabled = true;
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                if (e.getPath() != null && FilterTree.this.mExpandListenerIsEnabled) {
                    ((FilterNode)e.getPath().getLastPathComponent()).setWasExpanded(false);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                if (e.getPath() != null && FilterTree.this.mExpandListenerIsEnabled) {
                    ((FilterNode)e.getPath().getLastPathComponent()).setWasExpanded(true);
                }
            }
        });
        this.getSelectionModel().setSelectionMode(1);
        new OverlayListener(this);
        new DragSource().createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        this.mTransferNode = (FilterNode)this.getLastSelectedPathComponent();
        if (this.mTransferNode != null) {
            dge.startDrag(null, new FilterTransferNode());
        }
    }

    private int getTargetFor(FilterNode node, Point p, int row) {
        Rectangle location = this.getRowBounds(this.getClosestRowForLocation(p.x, p.y));
        if (node.isDirectoryNode()) {
            if (row != this.getRowCount() && p.y - location.y <= location.height / 4) {
                return -1;
            }
            if (row != this.getRowCount() && p.y - location.y <= location.height - location.height / 4) {
                return 0;
            }
            return 1;
        }
        if (p.y - location.y <= location.height / 2) {
            return -1;
        }
        return 1;
    }

    private boolean calculateCueLine(Point p) {
        TreePath path;
        int row = this.getClosestRowForLocation(p.x, p.y);
        Rectangle rowBounds = this.getRowBounds(row);
        if (rowBounds.y + rowBounds.height < p.y) {
            row = this.getRowCount();
        }
        if ((path = this.getPathForRow(row)) == null) {
            path = new TreePath(this.mRootNode);
        }
        if (this.mTransferNode != null && !new TreePath(this.mTransferNode.getPath()).isDescendant(path)) {
            FilterNode last = (FilterNode)path.getLastPathComponent();
            FilterNode pointed = last;
            int target = this.getTargetFor(pointed, p, row);
            if ((target == -1 || target == 1 && !this.isExpanded(new TreePath(pointed.getPath()))) && !last.isRoot()) {
                last = (FilterNode)last.getParent();
            }
            if (this.mTarget == 0 && System.currentTimeMillis() - this.mDragOverStart > 1000L && this.isCollapsed(new TreePath(last.getPath())) && last.getChildCount() > 0) {
                this.expandPath(new TreePath(last.getPath()));
                SwingUtilities.invokeLater(() -> {
                    this.mTarget = -2;
                });
            }
            if (this.mTargetNode != last || this.mTarget != target) {
                Rectangle rect;
                int y;
                this.mTargetNode = last;
                this.mTarget = target;
                this.mDragOverStart = System.currentTimeMillis();
                this.paintImmediately(this.mCueLine.getBounds());
                int n = y = row != this.getRowCount() ? rowBounds.y : rowBounds.y + rowBounds.height;
                if (target == -1) {
                    rect = new Rectangle(rowBounds.x, y - 1, rowBounds.width, 2);
                    this.mCueLine.setRect(rect);
                } else if (target == 0) {
                    rect = new Rectangle(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
                    this.mCueLine.setRect(rect);
                } else if (target == 1) {
                    rect = new Rectangle(rowBounds.x, y + rowBounds.height - 1, rowBounds.width, 2);
                    if (row == this.getRowCount()) {
                        rect = new Rectangle(0, y - 1, this.getWidth(), 2);
                    }
                    this.mCueLine.setRect(rect);
                }
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                Color c = new Color(255, 0, 0, this.mCueLine.getHeight() > 2.0 ? 40 : 180);
                g2.setColor(c);
                g2.fill(this.mCueLine);
            }
            return true;
        }
        return false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.getCurrentDataFlavors().length > 1 || dtde.getCurrentDataFlavors().length < 1 || !dtde.getCurrentDataFlavors()[0].equals(FILTER_FLAVOR)) {
            dtde.rejectDrag();
        } else if (this.calculateCueLine(dtde.getLocation())) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.paintImmediately(this.mCueLine.getBounds());
        this.mCueLine.setRect(0.0, 0.0, 0.0, 0.0);
        this.mTarget = -2;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getCurrentDataFlavors().length > 1 || dtde.getCurrentDataFlavors().length < 1 || !dtde.getCurrentDataFlavors()[0].equals(FILTER_FLAVOR)) {
            this.paintImmediately(this.mCueLine.getBounds());
            dtde.rejectDrag();
        } else if (this.calculateCueLine(dtde.getLocation())) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
        if (this.getVisibleRect().width < this.getSize().width || this.getVisibleRect().height < this.getSize().height) {
            int scroll = 20;
            if (dtde.getLocation().y + scroll + 5 > this.getVisibleRect().height) {
                this.scrollRectToVisible(new Rectangle(dtde.getLocation().x, dtde.getLocation().y + scroll + 5, 1, 1));
            }
            if (dtde.getLocation().y - scroll < this.getVisibleRect().y) {
                this.scrollRectToVisible(new Rectangle(dtde.getLocation().x, dtde.getLocation().y - scroll, 1, 1));
            }
            if (dtde.getLocation().x - scroll < this.getVisibleRect().x) {
                this.scrollRectToVisible(new Rectangle(dtde.getLocation().x - scroll, dtde.getLocation().y, 1, 1));
            }
            if (dtde.getLocation().x + scroll + 5 > this.getVisibleRect().width) {
                this.scrollRectToVisible(new Rectangle(dtde.getLocation().x + scroll + 5, dtde.getLocation().y, 1, 1));
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(dtde.getDropAction());
        this.paintImmediately(this.mCueLine.getBounds());
        Transferable transfer = dtde.getTransferable();
        if (transfer.isDataFlavorSupported(new DataFlavor(TreePath.class, "FilterNodeExport"))) {
            try {
                FilterNode last;
                FilterNode node = this.mTransferNode;
                FilterNode parent = (FilterNode)node.getParent();
                int row = this.getClosestRowForLocation(dtde.getLocation().x, dtde.getLocation().y);
                TreePath path = new TreePath(this.mRootNode);
                if (this.getRowBounds((int)row).y + this.getRowBounds((int)row).height < dtde.getLocation().y) {
                    row = this.getRowCount();
                } else {
                    path = this.getPathForRow(row);
                }
                if (path == null) {
                    path = new TreePath(this.mRootNode);
                }
                FilterNode pointed = last = (FilterNode)path.getLastPathComponent();
                int target = this.getTargetFor(pointed, dtde.getLocation(), row);
                if (!new TreePath(node.getPath()).isDescendant(path)) {
                    this.setSelectionPath(null);
                    parent.remove(node);
                    int n = -1;
                    if (target == -1 || target == 1 && !this.isExpanded(new TreePath(pointed.getPath()))) {
                        if (last.isRoot()) {
                            n = 0;
                        } else {
                            n = last.getParent().getIndex(last);
                            last = (FilterNode)last.getParent();
                        }
                    }
                    if (target == -1) {
                        last.insert(node, n);
                    } else if (target == 0) {
                        if (this.isExpanded(new TreePath(last))) {
                            last.insert(node, 0);
                        } else {
                            last.add(node);
                        }
                    } else if (row != this.getRowCount()) {
                        last.insert(node, n + 1);
                    } else {
                        last.add(node);
                    }
                    this.expandPath(new TreePath(last.getPath()));
                    this.mExpandListenerIsEnabled = false;
                    this.expand(last);
                    this.mExpandListenerIsEnabled = true;
                }
                this.updateUI();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public FilterNode getRoot() {
        return this.mRootNode;
    }

    private void expandAll(FilterNode node) {
        if (node.isDirectoryNode()) {
            this.expandPath(new TreePath(node.getPath()));
            for (int i = 0; i < node.getChildCount(); ++i) {
                FilterNode child = (FilterNode)node.getChildAt(i);
                if (!child.isDirectoryNode()) continue;
                this.expandPath(new TreePath(child.getPath()));
                this.expandAll(child);
            }
        }
    }

    private void collapseAll(FilterNode node) {
        if (node.isDirectoryNode()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FilterNode child = (FilterNode)node.getChildAt(i);
                if (!child.isDirectoryNode()) continue;
                this.collapseAll(child);
                this.collapsePath(new TreePath(child.getPath()));
            }
            if (!node.equals(this.mRootNode)) {
                this.collapsePath(new TreePath(node.getPath()));
            }
        }
    }

    private void expand(FilterNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (!(child instanceof FilterNode) || !((FilterNode)child).isDirectoryNode()) continue;
            this.expand((FilterNode)child);
        }
        if (node.wasExpanded()) {
            this.expandPath(new TreePath(this.getModel().getPathToRoot(node)));
        } else {
            this.collapsePath(new TreePath(this.getModel().getPathToRoot(node)));
        }
    }

    @Override
    public FilterTreeModel getModel() {
        return (FilterTreeModel)super.getModel();
    }

    private void showContextMenu(Point p) {
        JMenuItem item;
        JPopupMenu menu = new JPopupMenu();
        int row = this.getClosestRowForLocation(p.x, p.y);
        if (row >= 0 && row < this.getRowCount()) {
            this.setSelectionRow(row);
        }
        FilterNode last = this.getSelectedFilterNode();
        TreePath path = new TreePath(last.getPath());
        if (last.isDirectoryNode() && last.getChildCount() > 0) {
            item = new JMenuItem(this.isExpanded(path) ? LOCALIZER.msg("collapse", "Collapse") : LOCALIZER.msg("expand", "Expand"));
            item.setFont(item.getFont().deriveFont(1));
            item.addActionListener(e -> {
                if (this.isExpanded(path)) {
                    this.collapsePath(path);
                } else {
                    this.expandPath(path);
                }
            });
            if (!last.equals(this.mRootNode)) {
                menu.add(item);
            }
            item = new JMenuItem(LOCALIZER.msg("expandAll", "Expand all"));
            item.addActionListener(e -> this.expandAll(last));
            menu.add(item);
            item = new JMenuItem(LOCALIZER.msg("collapseAll", "Collapse all"));
            item.addActionListener(e -> this.collapseAll(last));
            menu.add(item);
            item = new JMenuItem(SelectFilterDlg.LOCALIZER.msg("sortAlphabetically", "Sort filters alphabetically"), IconLoader.getInstance().getIconFromTheme("actions", "sort-list", 16));
            item.addActionListener(e -> this.sortAlphabetically(last));
            menu.add(item);
            menu.addSeparator();
        }
        if (!last.isDirectoryNode() && last.getFilter() instanceof UserFilter) {
            item = new JMenuItem(LOCALIZER.ellipsisMsg("editFilter", "Edit filter '{0}'", last.getFilter().getName()), TVBrowserIcons.edit(16));
            item.setFont(item.getFont().deriveFont(1));
            item.addActionListener(e -> SelectFilterDlg.getInstance().editSelectedFilter(last));
            menu.add(item);
            menu.addSeparator();
        }
        item = new JMenuItem(LOCALIZER.msg("newFolder", "New folder"), IconLoader.getInstance().getIconFromTheme("actions", "folder-new", 16));
        item.addActionListener(e -> SelectFilterDlg.getInstance().createNewFolder(last));
        menu.add(item);
        item = new JMenuItem(LOCALIZER.msg("newFilter", "New Filter"), TVBrowserIcons.newIcon(16));
        item.addActionListener(e -> SelectFilterDlg.getInstance().createNewFilter(last));
        menu.add(item);
        if (last.isDirectoryNode() && !last.equals(this.mRootNode)) {
            item = new JMenuItem(LOCALIZER.msg("renameFolder", "Rename folder"), TVBrowserIcons.edit(16));
            item.addActionListener(e -> this.renameFolder(last));
            menu.add(item);
        }
        item = new JMenuItem(LOCALIZER.msg("newSeparator", "Add separator"), IconLoader.getInstance().getIconFromTheme("emblems", "separator", 16));
        item.addActionListener(e -> SelectFilterDlg.getInstance().addSeparator(last));
        menu.add(item);
        if (last.isUserDeletingAllowed()) {
            item = new JMenuItem(Localizer.getLocalization("i18n_delete"), TVBrowserIcons.delete(16));
            item.addActionListener(e -> SelectFilterDlg.getInstance().deleteSelectedItem(last));
            if (!last.equals(this.mRootNode) && last.getChildCount() < 1) {
                menu.add(item);
            }
        }
        if (last.containsFilter()) {
            String id = last.getFilter().getClass().getName();
            String name = last.getFilter().getName();
            if (!(Settings.General.FILTER_DEFAULT.getString().equals(id + "###" + name) || Settings.General.FILTER_DEFAULT.getString().trim().length() < 1 && last.getFilter() instanceof ShowAllFilter)) {
                item = new JMenuItem(LOCALIZER.msg("setDefault", "Set as default"), IconLoader.getInstance().getIconFromTheme("actions", "view-filter", 16));
                item.addActionListener(e -> SelectFilterDlg.getInstance().setDefaultFilter(last));
                menu.addSeparator();
                menu.add(item);
            }
        }
        menu.show(this, p.x, p.y);
    }

    protected void reload(FilterNode node) {
        this.mExpandListenerIsEnabled = false;
        this.getModel().reload(this, node);
        this.mExpandListenerIsEnabled = true;
    }

    void sortAlphabetically(FilterNode node) {
        FilterList.getInstance().getFilterTreeModel().sort(node, new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode node1, TreeNode node2) {
                return node1.toString().compareToIgnoreCase(node2.toString());
            }
        }, SelectFilterDlg.LOCALIZER.msg("sortAlphabetically", "Sort filters alphabetically"));
        this.reload(node);
    }

    protected void moveSelectedFilter(int rowCount) {
        TreePath path;
        int row;
        FilterNode src = (FilterNode)this.getSelectionPath().getLastPathComponent();
        if (src.isDirectoryNode()) {
            this.collapseAll(src);
        }
        if ((row = this.getRowForPath(this.getSelectionPath())) != -1 && (path = this.getPathForRow(row + rowCount)) != null) {
            FilterNode srcParent = (FilterNode)src.getParent();
            FilterNode target = (FilterNode)path.getLastPathComponent();
            FilterNode tarParent = target.equals(this.mRootNode) ? this.mRootNode : (FilterNode)target.getParent();
            int n = tarParent.getIndex(target);
            srcParent.remove(src);
            if (n > -1) {
                tarParent.insert(src, n);
            } else {
                tarParent.add(src);
            }
            this.reload(srcParent);
            this.reload(tarParent);
            this.setSelectionPath(new TreePath(src.getPath()));
            this.expandPath(new TreePath(tarParent.getPath()));
            this.mExpandListenerIsEnabled = false;
            this.expand(tarParent);
            this.mExpandListenerIsEnabled = true;
        }
    }

    protected void renameFolder(FilterNode node) {
        String value;
        if (node != null && node.isDirectoryNode() && (value = JOptionPane.showInputDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("folderName", "Folder name:"), node.getUserObject())) != null) {
            node.setUserObject(value);
            this.updateUI();
        }
    }

    protected FilterNode findFilter(ProgramFilter filter) {
        return this.findFilter(filter, this.getRoot());
    }

    private FilterNode findFilter(ProgramFilter filter, FilterNode root) {
        if (root.isDirectoryNode()) {
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                TreeNode child = e.nextElement();
                if (!(child instanceof FilterNode)) continue;
                if (((FilterNode)child).isDirectoryNode()) {
                    FilterNode result = this.findFilter(filter, (FilterNode)child);
                    if (result == null) continue;
                    return result;
                }
                if (!((FilterNode)child).getFilter().equals(filter)) continue;
                return (FilterNode)child;
            }
        }
        return null;
    }

    private FilterNode getSelectedFilterNode() {
        TreePath path1 = null;
        int[] selectionRows = this.getSelectionRows();
        if (selectionRows != null && selectionRows.length > 0) {
            path1 = this.getPathForRow(selectionRows[0]);
        }
        if (path1 == null) {
            path1 = new TreePath(this.mRootNode);
        }
        TreePath path = path1;
        FilterNode last = (FilterNode)path.getLastPathComponent();
        this.setSelectionPath(path);
        return last;
    }

    private static class FilterTransferNode
    implements Transferable {
        private FilterTransferNode() {
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{FILTER_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.getMimeType().equals(FILTER_FLAVOR.getMimeType()) && df.getHumanPresentableName().equals(FILTER_FLAVOR.getHumanPresentableName());
        }
    }

    private static class FilterTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private FilterTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, final boolean sel, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, cellHasFocus);
            if (label != null && UiUtilities.isGTKLookAndFeel()) {
                label.setBackground(tree.getBackground());
                label.setOpaque(!sel && !cellHasFocus);
            }
            if (leaf && value instanceof FilterNode && ((FilterNode)value).isDirectoryNode()) {
                label.setIcon(this.getClosedIcon());
            }
            if (value instanceof FilterNode) {
                FilterNode test = (FilterNode)value;
                if (test.containsFilter()) {
                    String id = test.getFilter().getClass().getName();
                    String name = test.getFilter().getName();
                    if (Settings.General.FILTER_DEFAULT.getString().equals(id + "###" + name) || Settings.General.FILTER_DEFAULT.getString().trim().length() < 1 && test.getFilter() instanceof ShowAllFilter) {
                        label = new JLabel(label.getText());
                        label.setFont(label.getFont().deriveFont(1));
                        if (sel) {
                            label.setOpaque(true);
                            label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                            label.setForeground(UIManager.getColor("Tree.selectionForeground"));
                        }
                    }
                    if (Settings.Markings.HIGHLIGHTING_FILTERS.containsKey(name)) {
                        int style = label.getFont().getStyle();
                        label = new JLabel(label.getText());
                        label.setFont(label.getFont().deriveFont(style | 2));
                        if (sel) {
                            label.setOpaque(true);
                            label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                            label.setForeground(UIManager.getColor("Tree.selectionForeground"));
                        }
                    }
                    if (test.getFilter() instanceof UserFilter) {
                        label.setText(((UserFilter)test.getFilter()).getViewString());
                    }
                } else if (test.containsSeparator()) {
                    label.setText("");
                    label.setIcon(new Icon(){

                        @Override
                        public int getIconHeight() {
                            return 16;
                        }

                        @Override
                        public int getIconWidth() {
                            return 64;
                        }

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                            if (sel) {
                                g.setColor(UIManager.getColor("Tree.selectionBackground"));
                                g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
                            }
                            g.setColor(c.getForeground());
                            g.drawLine(4, this.getIconHeight() / 2 - 1, this.getIconWidth() - 4, this.getIconHeight() / 2 - 1);
                            g.drawLine(4, this.getIconHeight() / 2, this.getIconWidth() - 4, this.getIconHeight() / 2);
                        }
                    });
                }
            }
            if (UiUtilities.isNimbusLookAndFeel()) {
                if (sel) {
                    label.setOpaque(true);
                    label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    label.setOpaque(false);
                }
            }
            return label;
        }
    }

    private class FilterTreeUI
    extends BasicTreeUI
    implements MouseListener {
        private static final int CLICK_WAIT_TIME = 150;
        private Thread mClickedThread;
        private TreePath mLastSelectionPath;
        private long mMousePressedTime;
        private boolean mWasExpanded;

        private FilterTreeUI() {
        }

        @Override
        protected MouseListener createMouseListener() {
            return this;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                TreePath path;
                if (!this.tree.isFocusOwner()) {
                    this.tree.requestFocusInWindow();
                }
                if ((path = this.getClosestPathForLocation(this.tree, e.getX(), e.getY())) != null && this.getPathBounds(this.tree, path).contains(e.getPoint())) {
                    FilterTree.this.setSelectionPath(path);
                }
                if (e.isPopupTrigger()) {
                    FilterTree.this.showContextMenu(e.getPoint());
                }
                this.mMousePressedTime = e.getWhen();
                this.checkForClickInExpandControl(this.getClosestPathForLocation(this.tree, e.getX(), e.getY()), e.getX(), e.getY());
                if (SelectFilterDlg.getInstance() != null) {
                    SelectFilterDlg.getInstance().updateBtns();
                }
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed()) {
                if (e.isPopupTrigger()) {
                    FilterTree.this.showContextMenu(e.getPoint());
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    final TreePath path = this.getClosestPathForLocation(this.tree, e.getX(), e.getY());
                    if (path != null && ((FilterNode)path.getLastPathComponent()).containsFilter()) {
                        this.mLastSelectionPath = path;
                        if (e.getClickCount() >= 2) {
                            SelectFilterDlg.getInstance().editSelectedFilter((FilterNode)path.getLastPathComponent());
                        }
                    } else if (path != null && ((FilterNode)path.getLastPathComponent()).isDirectoryNode() && e.getWhen() - this.mMousePressedTime < 150L && this.getPathBounds(this.tree, path).contains(e.getPoint())) {
                        if (this.mClickedThread == null || !this.mClickedThread.isAlive()) {
                            this.mClickedThread = new Thread("Double click filter"){

                                @Override
                                public void run() {
                                    if (!FilterTree.this.isExpanded(path)) {
                                        FilterTree.this.expandPath(path);
                                        FilterTreeUI.this.mWasExpanded = true;
                                    } else if (FilterTreeUI.this.mLastSelectionPath != null && FilterTreeUI.this.tree.getSelectionPath().equals(FilterTreeUI.this.mLastSelectionPath)) {
                                        FilterTree.this.collapsePath(path);
                                        FilterTreeUI.this.mWasExpanded = false;
                                    }
                                    FilterTree.this.setSelectionPath(path);
                                    FilterTreeUI.this.mLastSelectionPath = path;
                                    try {
                                        Thread.sleep(300L);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    FilterTreeUI.this.mWasExpanded = false;
                                }
                            };
                            this.mClickedThread.start();
                        } else if (!this.mWasExpanded && this.mLastSelectionPath != null && this.tree.getSelectionPath().equals(this.mLastSelectionPath)) {
                            FilterTree.this.collapsePath(path);
                        }
                    } else {
                        this.mLastSelectionPath = path;
                    }
                }
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

