/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import java.util.Locale;
import tvbrowser.core.filters.FilterComponent;

public class FilterItem {
    static String AND_KEY = "and";
    static String OR_KEY = "or";
    static String NOT_KEY = "not";
    static String OPEN_BRACKET_KEY = "open_bracket";
    static String CLOSE_BRACKET_KEY = "close_bracket";
    private String mRuleType;
    private FilterComponent mComponent;
    private int mLevel;

    private FilterItem(String ruleType, int level, FilterComponent comp) {
        this.mRuleType = ruleType;
        this.mLevel = level;
        this.mComponent = comp;
    }

    public FilterItem(String ruleType, int level) {
        this.mRuleType = ruleType;
        this.mComponent = null;
        this.mLevel = level;
    }

    public FilterItem(FilterComponent comp, int level) {
        this.mRuleType = null;
        this.mComponent = comp;
        this.mLevel = level;
    }

    public String toString() {
        if (this.mRuleType != null) {
            if (Locale.getDefault().getLanguage().equals("de")) {
                if (this.mRuleType.equals(AND_KEY)) {
                    return "UND";
                }
                if (this.mRuleType.equals(OR_KEY)) {
                    return "ODER";
                }
                if (this.mRuleType.equals(NOT_KEY)) {
                    return "NICHT";
                }
            } else {
                if (this.mRuleType.equals(AND_KEY)) {
                    return "AND";
                }
                if (this.mRuleType.equals(OR_KEY)) {
                    return "OR";
                }
                if (this.mRuleType.equals(NOT_KEY)) {
                    return "NOT";
                }
            }
            if (this.mRuleType.equals(OPEN_BRACKET_KEY)) {
                return "(";
            }
            if (this.mRuleType.equals(CLOSE_BRACKET_KEY)) {
                return ")";
            }
        }
        return this.mComponent.getName();
    }

    public void setLevel(int level) {
        this.mLevel = level;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public FilterComponent getComponent() {
        return this.mComponent;
    }

    public FilterItem clone(int level) {
        return new FilterItem(this.mRuleType, level, this.mComponent);
    }

    public boolean isOpenBracketItem() {
        return this.mRuleType != null && this.mRuleType.equals(OPEN_BRACKET_KEY);
    }

    public boolean isCloseBracketItem() {
        return this.mRuleType != null && this.mRuleType.equals(CLOSE_BRACKET_KEY);
    }

    public boolean isAndItem() {
        return this.mRuleType != null && this.mRuleType.equals(AND_KEY);
    }

    public boolean isOrItem() {
        return this.mRuleType != null && this.mRuleType.equals(OR_KEY);
    }

    public boolean isNotItem() {
        return this.mRuleType != null && this.mRuleType.equals(NOT_KEY);
    }
}

