/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ContextMenuIf;
import devplugin.Marker;
import devplugin.PluginCenterPanelWrapper;
import devplugin.Program;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.swing.Icon;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.extras.common.AbstractInternalPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderSettingsTab;
import util.i18n.Localizer;

public class ReminderPluginProxy
extends AbstractInternalPluginProxy
implements ButtonActionIf,
ContextMenuIf,
Marker {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderPluginProxy.class);
    private static final String PROGRAM_TARGET_REMIND = "target_remind";
    private static ReminderPluginProxy mInstance;
    private Icon mMarkIcon;
    private ProgramReceiveTarget mProgramReceiveTarget;

    private ReminderPluginProxy() {
        mInstance = this;
        this.mProgramReceiveTarget = new ProgramReceiveTarget(3, this, mLocalizer.msg("programTarget", "Remind"), PROGRAM_TARGET_REMIND);
    }

    public static ReminderPluginProxy getInstance() {
        if (mInstance == null) {
            new ReminderPluginProxy();
        }
        return mInstance;
    }

    @Override
    public ActionMenu getContextMenuActions(Program program) {
        return ReminderPluginProxy.getReminderInstance().getContextMenuActions(program);
    }

    @Override
    public String getId() {
        return ReminderPlugin.getReminderPluginId();
    }

    @Override
    public String toString() {
        return ReminderPlugin.getName();
    }

    @Override
    public boolean receivePrograms(int type, Program[] programArr, ProgramReceiveTarget receiveTarget) {
        boolean result = false;
        if (receiveTarget.isReceiveTargetWithIdOfProgramReceiveIf(this, PROGRAM_TARGET_REMIND)) {
            if (type == 0 || type == 1) {
                ReminderPluginProxy.getReminderInstance().addPrograms(programArr);
            } else if (type == 2) {
                ReminderPluginProxy.getReminderInstance().removePrograms(programArr);
            }
            result = true;
        }
        return result;
    }

    @Override
    public ProgramReceiveTarget[] getProgramReceiveTargets() {
        return new ProgramReceiveTarget[]{this.mProgramReceiveTarget};
    }

    @Override
    public Icon getMarkIcon() {
        if (this.mMarkIcon == null) {
            this.mMarkIcon = IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16);
        }
        return this.mMarkIcon;
    }

    @Override
    public Icon[] getMarkIcons(Program p) {
        return new Icon[]{this.getMarkIcon()};
    }

    @Override
    @Deprecated(since="4.2.2")
    public int getMarkPriorityForProgram(Program p) {
        return this.getMarkPriorityMaxForProgram(p);
    }

    @Override
    public String getButtonActionDescription() {
        return ReminderPlugin.LOCALIZER.msg("description", "The reminder function of TV-Browser.");
    }

    @Override
    public Icon getIcon() {
        return this.getMarkIcon();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public SettingsTab getSettingsTab() {
        return new ReminderSettingsTab();
    }

    @Override
    public String getSettingsId() {
        return "#reminder";
    }

    @Override
    public ActionMenu getButtonAction() {
        return ReminderPlugin.getInstance().getButtonAction();
    }

    @Override
    public void handleTvDataUpdateFinished() {
        ReminderPluginProxy.getReminderInstance().handleTvDataUpdateFinished();
    }

    private static ReminderPlugin getReminderInstance() {
        return ReminderPlugin.getInstance();
    }

    @Override
    public String getPluginCategory() {
        return "misc";
    }

    @Override
    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return ReminderPlugin.getInstance().getPluginCenterPanelWrapper();
    }

    @Override
    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        return ReminderPlugin.getInstance().getAfterDataUpdateInfoPanel();
    }

    @Override
    public void handleTvBrowserStartFinished() {
        ReminderPlugin.getInstance().handleTvBrowserStartFinished();
    }

    @Override
    public int getMarkPriorityMaxForProgram(Program p) {
        return ReminderPluginProxy.getReminderInstance().getMarkPriority();
    }

    @Override
    public int[] getMarkPrioritiesForProgram(Program p) {
        return new int[]{this.getMarkPriorityMaxForProgram(p)};
    }

    @Override
    public boolean canReceiveProgramsWithTarget() {
        return true;
    }

    @Override
    public void writeData(ObjectOutputStream out) throws IOException {
        ReminderPlugin.getInstance().writeData(out);
    }

    @Override
    public void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ReminderPlugin.getInstance().readData(in);
    }

    @Override
    public Properties storeSettings() {
        return ReminderPlugin.getInstance().getSettings().storeSettings();
    }

    @Override
    public void loadSettings(Properties prop) {
        ReminderPlugin.getInstance().loadSettings(prop);
    }

    @Override
    public boolean hasToSaveSettings() {
        return ReminderPlugin.getInstance().hasToSaveSettings();
    }
}

