/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ContextMenuAction;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Date;
import devplugin.PluginCenterPanel;
import devplugin.PluginCenterPanelWrapper;
import devplugin.PluginTreeNode;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.reminderplugin.FrameReminders;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderDialog;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListDialog;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderListPanel;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderSettings;
import tvbrowser.extras.reminderplugin.ReminderTimerListener;
import tvbrowser.extras.reminderplugin.RemovedProgramsPanel;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public class ReminderPlugin {
    static Localizer LOCALIZER = Localizer.getLocalizerFor(ReminderPlugin.class);
    private static KeyStroke STROKE_FRAME_REMINDERS_SHOW = null;
    private ReminderList mReminderList;
    private ReminderSettings mReminderSettings;
    private static ReminderPlugin mInstance;
    private static String DATAFILE_PREFIX;
    private static final PluginTreeNode mRootNode;
    private boolean mHasRightToStartTimer = false;
    private boolean mHasRightToSave = true;
    private static final String TOGGLE_ACTION_ID = "reminderPauseAction";
    public static final String REMINDER_LIST_ACTION_ID = "reminderListAction";
    private ProgramReceiveTarget[] mClientPluginTargets;
    private int mMarkPriority = -2;
    private PluginCenterPanelWrapper mWrapper;
    private JPanel mCenterPanel;
    private ReminderListPanel mReminderListPanel;
    private AbstractAction toggleTimer;
    private Thread mInfoCreationThread;
    private AfterDataUpdateInfoPanel mInfoPanel;
    private boolean mHasToSaveSettings;

    static KeyStroke getKeyStrokeFrameReminders() {
        if (STROKE_FRAME_REMINDERS_SHOW == null) {
            STROKE_FRAME_REMINDERS_SHOW = KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        }
        return STROKE_FRAME_REMINDERS_SHOW;
    }

    void endPause() {
        this.toggleTimer.putValue("Name", LOCALIZER.msg("stopTimer", "Pause Reminder"));
        this.toggleTimer.putValue("ShortDescription", LOCALIZER.msg("stopTimerDesc", "Pause Reminder until reactivation"));
        this.toggleTimer.putValue("ActionIsSelected", false);
        MainFrame.getInstance().updateToolbar();
    }

    private void startPause(int minutes) {
        this.mReminderList.pauseReminder(minutes);
        int time = IOUtilities.getMinutesAfterMidnight() + minutes;
        if (time >= 1440) {
            time -= 1440;
        }
        this.toggleTimer.putValue("Name", LOCALIZER.msg("endPause", "Paused until {0}. Continue Reminder now", IOUtilities.timeToString(time)));
        this.toggleTimer.putValue("ActionIsSelected", true);
        MainFrame.getInstance().updateToolbar();
    }

    private ReminderPlugin() {
        mInstance = this;
        this.mHasToSaveSettings = false;
        this.toggleTimer = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ReminderPlugin.this.mReminderList != null) {
                    ReminderPlugin.this.mReminderList.toggleTimer();
                    if (ReminderPlugin.this.mReminderList.isActive()) {
                        this.putValue("Name", LOCALIZER.msg("stopTimer", "Pause Reminder"));
                        this.putValue("ShortDescription", LOCALIZER.msg("stopTimerDesc", "Pause Reminder until reactivation"));
                        this.putValue("ActionIsSelected", false);
                    } else {
                        this.putValue("Name", LOCALIZER.msg("continueTimer", "Continue Reminder"));
                        this.putValue("ShortDescription", LOCALIZER.msg("continueTimer", "Continue Reminder"));
                        this.putValue("ActionIsSelected", true);
                    }
                    MainFrame.getInstance().updateToolbar();
                }
            }
        };
        this.toggleTimer.putValue("Name", LOCALIZER.msg("stopTimer", "Pause Reminder"));
        this.toggleTimer.putValue("ActionId", TOGGLE_ACTION_ID);
        this.toggleTimer.putValue("ShortDescription", LOCALIZER.msg("stopTimerDesc", "Pause Reminder until reactivation"));
        this.toggleTimer.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 16));
        this.toggleTimer.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 22));
        this.toggleTimer.putValue("ActionType", 1);
        this.toggleTimer.putValue("ActionIsSelected", false);
        this.toggleTimer.putValue("####KEYBOARD_ACCELERATOR####", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.mWrapper = new PluginCenterPanelWrapper(){
            ReminderCenterPanel centerPanel;
            {
                this.centerPanel = new ReminderCenterPanel();
            }

            @Override
            public PluginCenterPanel[] getCenterPanels() {
                return new PluginCenterPanel[]{this.centerPanel};
            }

            @Override
            public void scrolledToDate(Date date) {
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    ReminderPlugin.this.mReminderListPanel.scrollTo(0, date, -1);
                }
            }

            @Override
            public void scrolledToNow() {
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    ReminderPlugin.this.mReminderListPanel.scrollTo(1, null, -1);
                }
            }

            @Override
            public void scrolledToTime(int time) {
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    int type = 2;
                    if (!ReminderPlugin.this.mReminderSettings.isSet("scrollTimeTypeNext")) {
                        type = 3;
                    }
                    ReminderPlugin.this.mReminderListPanel.scrollTo(type, null, time);
                }
                super.scrolledToTime(time);
            }
        };
        this.mCenterPanel = UiUtilities.createPersonaBackgroundPanel();
        this.mClientPluginTargets = new ProgramReceiveTarget[0];
        this.mReminderList = new ReminderList();
    }

    public static synchronized ReminderPlugin getInstance() {
        if (mInstance == null) {
            new ReminderPlugin();
        }
        return mInstance;
    }

    public String toString() {
        return ReminderPlugin.getName();
    }

    static String getName() {
        return LOCALIZER.msg("pluginName", "Reminder");
    }

    public void handleTvBrowserStartFinished() {
        this.updateRootNode(false);
        this.mHasRightToStartTimer = true;
        this.mReminderList.updateItems();
        this.mReminderList.startTimer();
        this.addPanel();
    }

    void addPanel() {
        SwingUtilities.invokeLater(() -> {
            if (this.mReminderSettings.isSet("provideTab")) {
                if (this.mReminderListPanel == null) {
                    this.mReminderListPanel = new ReminderListPanel(this.mReminderList, null);
                    Persona.getInstance().registerPersonaListener(this.mReminderListPanel);
                    SwingUtilities.invokeLater(() -> {
                        this.mCenterPanel.add((Component)this.mReminderListPanel, "Center");
                        this.mReminderListPanel.updatePersona();
                        this.mCenterPanel.repaint();
                    });
                }
            } else {
                if (this.mReminderListPanel != null) {
                    Persona.getInstance().removePersonaListener(this.mReminderListPanel);
                }
                this.mReminderListPanel = null;
            }
        });
    }

    protected boolean isAllowedToStartTimer() {
        return this.mHasRightToStartTimer;
    }

    public ReminderSettings getSettings() {
        return this.mReminderSettings;
    }

    void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.mReminderList.setReminderTimerListener(null);
        this.mReminderList.read(in);
        if (version == 3) {
            this.mClientPluginTargets = new ProgramReceiveTarget[in.readInt()];
            for (int i = 0; i < this.mClientPluginTargets.length; ++i) {
                this.mClientPluginTargets[i] = new ProgramReceiveTarget(in);
            }
        }
        this.mReminderList.updateItems();
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){

            @Override
            public void tvDataUpdateStarted(Date until) {
                ReminderPlugin.this.mHasRightToSave = false;
            }

            @Override
            public void tvDataUpdateFinished() {
            }
        });
        this.mReminderList.setReminderTimerListener(new ReminderTimerListener(this.mReminderSettings, this.mReminderList));
    }

    void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        this.mReminderList.writeData(out);
        out.writeInt(this.mClientPluginTargets.length);
        for (ProgramReceiveTarget target : this.mClientPluginTargets) {
            target.writeData(out);
        }
    }

    void loadSettings(Properties settings) {
        if (settings == null) {
            settings = new Properties();
        }
        this.mReminderSettings = new ReminderSettings(settings);
        if (!this.mReminderSettings.hasProperty("usemsgbox") || this.mReminderSettings.isSet("usemsgbox") && !this.mReminderSettings.hasProperty("showFrameReminders")) {
            this.mReminderSettings.set("usemsgbox", false);
            this.mReminderSettings.set("showFrameReminders", true);
        }
        if (settings.getProperty("numberofremindoptions") != null && settings.getProperty("defaultReminderEntry") != null) {
            int defaultRemind = Integer.parseInt(settings.getProperty("defaultReminderEntry")) - 5;
            settings.setProperty("defaultReminderEntry", String.valueOf(defaultRemind));
            settings.remove("numberofremindoptions");
        } else if (settings.getProperty("defaultReminderEntry") == null) {
            settings.setProperty("defaultReminderEntry", String.valueOf(0));
        }
        if (settings.containsKey("usethisplugin") || settings.containsKey("usesendplugin")) {
            String plugins = settings.getProperty("usethisplugin", "").trim();
            boolean sendEnabled = settings.getProperty("usesendplugin", "").compareToIgnoreCase("true") == 0;
            settings.remove("usethisplugin");
            settings.remove("usesendplugin");
            if (plugins.length() > 0 && sendEnabled) {
                if (plugins.indexOf(59) == -1) {
                    this.mClientPluginTargets = new ProgramReceiveTarget[1];
                    this.mClientPluginTargets[0] = ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(plugins);
                } else {
                    String[] ids = plugins.split(";");
                    this.mClientPluginTargets = new ProgramReceiveTarget[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        this.mClientPluginTargets[i] = ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(ids[i]);
                    }
                }
            }
        }
        if (settings.containsKey("autoCloseReminderAtProgramEnd")) {
            if (settings.getProperty("autoCloseReminderAtProgramEnd", "true").equalsIgnoreCase("true")) {
                this.mReminderSettings.set("autoCloseBehaviour", "onEnd");
            }
            settings.remove("autoCloseReminderAtProgramEnd");
        }
    }

    protected ActionMenu getContextMenuActions(final Window parentFrame, final Program program) {
        final ReminderListItem item = this.mReminderList.getReminderItem(program);
        RemindValue[] values = ReminderPlugin.calculatePossibleReminders(program);
        ArrayList<ActionMenu> actions = new ArrayList<ActionMenu>(values.length + 3);
        ContextMenuAction dontRemind = null;
        if (item != null && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            dontRemind = new ContextMenuAction(ReminderConstants.DONT_REMIND_AGAIN_VALUE.toString());
            dontRemind.setSmallIcon(IconLoader.getInstance().getIconFromTheme("actions", "appointment-new", 16));
            dontRemind.setActionListener(e -> {
                if (this.mReminderSettings.isSet("showFrameReminders")) {
                    FrameReminders.getInstance().removeReminder(item);
                }
                this.mReminderList.removeWithoutChecking(program);
                this.updateRootNode(true);
            });
        }
        for (final RemindValue value : values) {
            actions.add(new ActionMenu(value.getMinutes(), new AbstractAction(value.toString()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (item != null) {
                        if (item.getMinutes() == value.getMinutes()) {
                            ReminderPlugin.this.mReminderList.removeWithoutChecking(program);
                            if (ReminderPlugin.this.mReminderSettings.isSet("showFrameReminders")) {
                                FrameReminders.getInstance().removeReminder(item);
                            }
                            ReminderPlugin.this.updateRootNode(true);
                        } else {
                            item.setMinutes(value.getMinutes());
                            ReminderPlugin.this.saveReminders();
                            if (ReminderPlugin.this.mReminderSettings.isSet("showFrameReminders")) {
                                FrameReminders.getInstance().updateReminder(item);
                            }
                        }
                    } else {
                        ReminderPlugin.this.mReminderList.add(program, new ReminderContent(value.getMinutes()));
                        ReminderPlugin.this.mReminderList.unblockProgram(program);
                        ReminderPlugin.this.updateRootNode(true);
                    }
                }
            }, item != null && item.getMinutes() == value.getMinutes()));
        }
        if (item != null || program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            if (!actions.isEmpty()) {
                actions.add(new ActionMenu(ContextMenuSeparatorAction.getInstance()));
            }
            actions.add(new ActionMenu(Integer.MAX_VALUE, new AbstractAction(LOCALIZER.msg("comment", "Change comment"), TVBrowserIcons.edit(16)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    item.changeComment(parentFrame);
                    if (ReminderPlugin.this.mReminderSettings.isSet("showFrameReminders")) {
                        FrameReminders.getInstance().updateReminder(item);
                    }
                    ReminderPlugin.this.saveReminders();
                }
            }));
        }
        ContextMenuAction action = new ContextMenuAction();
        action.setText(LOCALIZER.msg("contextMenuText", "Remind me") + (String)(program.equals(PluginManagerImpl.getInstance().getExampleProgram()) ? "/" + ReminderConstants.DONT_REMIND_AGAIN_VALUE.toString() : ""));
        action.setSmallIcon(IconLoader.getInstance().getIconFromTheme("actions", "appointment-new", 16));
        action.setActionListener(event -> {
            Window w = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            try {
                UIThreadRunner.invokeAndWait(() -> {
                    ReminderDialog dlg = new ReminderDialog(w, program, this.mReminderSettings);
                    Settings.layoutWindow("extras.remiderContext", dlg);
                    if (this.mReminderSettings.isSet("showTimeSelectionDialog")) {
                        UiUtilities.centerAndShow(dlg);
                        if (dlg.getOkPressed()) {
                            this.mReminderList.add(program, dlg.getReminderContent());
                            this.mReminderList.unblockProgram(program);
                            this.updateRootNode(true);
                        }
                        dlg.dispose();
                    } else {
                        this.mReminderList.add(program, dlg.getReminderContent());
                        this.mReminderList.unblockProgram(program);
                        this.updateRootNode(true);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        ActionMenu result = null;
        if (!program.isExpired() || program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            if (this.mReminderList.contains(program)) {
                result = !actions.isEmpty() ? new ActionMenu(-1, ReminderPlugin.getName(), IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), new ActionMenu[]{new ActionMenu(Integer.MIN_VALUE, dontRemind), new ActionMenu(-2147483647, ReminderPlugin.getName(), IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), actions.toArray(new ActionMenu[actions.size()])), this.getDeleteMenu(program)}, true) : new ActionMenu(Integer.MIN_VALUE, dontRemind);
            } else if (!actions.isEmpty()) {
                result = new ActionMenu(-1, ReminderPlugin.getName(), IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), new ActionMenu[]{new ActionMenu(Integer.MIN_VALUE, action), new ActionMenu(-2147483647, ReminderPlugin.getName(), IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), actions.toArray(new ActionMenu[actions.size()]))}, true);
            }
        }
        return result;
    }

    ActionMenu getDeleteMenu(Program p) {
        ContextMenuAction removeAll = new ContextMenuAction(LOCALIZER.msg("contextMenu.deleteMenu.all", "Delete all reminders"), TVBrowserIcons.delete(16));
        removeAll.setActionListener(e -> {
            if (0 == JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("question.deleteAll", "Do you really want to delete all reminders?"), LOCALIZER.msg("question.title", "Delete reminders?"), 0, 3)) {
                ReminderListItem[] items;
                for (ReminderListItem item : items = this.mReminderList.getReminderItems()) {
                    this.mReminderList.removeWithoutChecking(item.getProgram());
                }
                this.updateRootNode(true);
            }
        });
        ContextMenuAction removeForChannel = new ContextMenuAction(LOCALIZER.msg("contextMenu.deleteMenu.forChannel", "Delete all reminders from channel '{0}'", p.getChannel().getName()), TVBrowserIcons.delete(16));
        removeForChannel.setActionListener(e -> {
            if (0 == JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("question.deleteAllChannel", "Do you really want to delete all reminders on channel '{0}'?", p.getChannel().getName()), LOCALIZER.msg("question.title", "Delete reminders?"), 0, 3)) {
                ReminderListItem[] items;
                for (ReminderListItem item : items = this.mReminderList.getReminderItems()) {
                    if (!item.getProgram().getChannel().equals(p.getChannel())) continue;
                    this.mReminderList.removeWithoutChecking(item.getProgram());
                }
                this.updateRootNode(true);
            }
        });
        ContextMenuAction removeForTitle = new ContextMenuAction(LOCALIZER.msg("contextMenu.deleteMenu.forTitle", "Delete all reminders with title '{0}'", p.getTitle()), TVBrowserIcons.delete(16));
        removeForTitle.setActionListener(e -> {
            if (0 == JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("question.deleteAllTitle", "Do you really want to delete all reminders with title\\n'{0}'?", p.getTitle()), LOCALIZER.msg("question.title", "Delete reminders?"), 0, 3)) {
                ReminderListItem[] items;
                for (ReminderListItem item : items = this.mReminderList.getReminderItems()) {
                    if (!item.getProgram().getTitle().equals(p.getTitle())) continue;
                    this.mReminderList.removeWithoutChecking(item.getProgram());
                }
                this.updateRootNode(true);
            }
        });
        return new ActionMenu(-1, LOCALIZER.msg("contextMenu.deleteMenu", "Delete reminders"), IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), new ActionMenu[]{new ActionMenu(-2147483548, removeAll), new ActionMenu(-2147483547, removeForChannel), new ActionMenu(-2147483546, removeForTitle)}, true);
    }

    public int getDefaultReminderTime() {
        String defaultReminderEntryStr = this.mReminderSettings.get("defaultReminderEntry");
        int minutes = 10;
        if (defaultReminderEntryStr != null) {
            try {
                int inx = Integer.parseInt(defaultReminderEntryStr);
                if (inx < ReminderConstants.REMIND_BEFORE_VALUE_ARR.length) {
                    minutes = ReminderConstants.REMIND_BEFORE_VALUE_ARR[inx].getMinutes();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return minutes;
    }

    public void addPrograms(Program[] programArr) {
        this.addPrograms(programArr, this.getDefaultReminderTime());
    }

    public void addPrograms(Program[] programArr, int reminderMinutes) {
        this.mReminderList.addAndCheckBlocked(programArr, reminderMinutes);
        this.updateRootNode(true);
    }

    public void updatePrograms(Program[] programArr, int reminderMinutes, int oldMinutesValue) {
        this.mReminderList.update(programArr, reminderMinutes, oldMinutesValue);
        this.updateRootNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeProgram(Program prog) {
        ReminderListItem item = null;
        ReminderList reminderList = this.mReminderList;
        synchronized (reminderList) {
            item = this.mReminderList.getReminderItem(prog);
            this.mReminderList.remove(prog);
        }
        if (item != null) {
            return item.getMinutes();
        }
        return -42;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrograms(Program[] progArr) {
        ReminderList reminderList = this.mReminderList;
        synchronized (reminderList) {
            this.mReminderList.remove(progArr);
        }
    }

    public void addProgram(Program prog, int reminderMinutes) {
        this.mReminderList.add(prog, new ReminderContent(reminderMinutes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReminderMinutesForProgram(Program prog) {
        ReminderListItem item = null;
        ReminderList reminderList = this.mReminderList;
        synchronized (reminderList) {
            item = this.mReminderList.getReminderItem(prog);
        }
        if (item != null) {
            return item.getMinutes();
        }
        return -31;
    }

    public static PluginTreeNode getRootNode() {
        return mRootNode;
    }

    synchronized void updateRootNode(boolean save, boolean scroll) {
        mRootNode.removeAllActions();
        mRootNode.getMutableTreeNode().setIcon(IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
        AbstractAction editReminders = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderListDialog dlg = new ReminderListDialog((Window)MainFrame.getInstance(), ReminderPlugin.this.mReminderList);
                UiUtilities.centerAndShow(dlg);
            }
        };
        editReminders.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
        editReminders.putValue("Name", LOCALIZER.ellipsisMsg("buttonText", "Edit reminder list"));
        AbstractAction openSettings = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showSettingsDialog("#reminder");
            }
        };
        openSettings.putValue("SmallIcon", TVBrowserIcons.preferences(16));
        openSettings.putValue("Name", Localizer.getLocalization("i18n_settings"));
        mRootNode.addAction(editReminders);
        mRootNode.addAction(null);
        mRootNode.addAction(openSettings);
        mRootNode.removeAllChildren();
        ReminderListItem[] items = this.mReminderList.getReminderItems();
        ArrayList<Program> listNewPrograms = new ArrayList<Program>(items.length);
        for (ReminderListItem reminderItem : items) {
            listNewPrograms.add(reminderItem.getProgram());
        }
        try {
            mRootNode.addPrograms(listNewPrograms);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mRootNode.update();
        if (save && this.mHasRightToSave) {
            this.saveReminders();
        }
        if (this.mReminderListPanel != null) {
            this.mReminderListPanel.installTableModel(scroll);
        }
    }

    public void updateRootNode(boolean save) {
        this.updateRootNode(save, true);
    }

    synchronized void saveReminders() {
        this.mHasToSaveSettings = true;
        InternalPluginProxyList.getInstance().storeData(ReminderPluginProxy.getInstance(), true);
        this.mHasToSaveSettings = false;
    }

    protected ActionMenu getButtonAction() {
        try {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ReminderPlugin.getInstance().showManageRemindersDialog();
                }
            };
            action.putValue("Name", LOCALIZER.msg("showReminderList", "Show Edit Reminder list"));
            action.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
            action.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 22));
            action.putValue("ShortDescription", LOCALIZER.msg("description", "Reminds you of programs to not miss them."));
            action.putValue("ActionId", REMINDER_LIST_ACTION_ID);
            AbstractAction actionShowCurrentReminders = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ReminderPlugin.this.mReminderSettings.isSet("showFrameReminders")) {
                        FrameReminders.getInstance().openShow();
                    } else {
                        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("info.noCollectedReminders.message", "The window with the collected Reminders is\nnot acitvated, therefor it cannot be shown."), LOCALIZER.msg("info.noCollectedReminders.title", "Collected Reminders not activated"), 1);
                    }
                }
            };
            actionShowCurrentReminders.putValue("Name", LOCALIZER.msg("showCurrentReminderList", "Show current Reminder list"));
            actionShowCurrentReminders.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16));
            actionShowCurrentReminders.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("apps", "appointment", 22));
            actionShowCurrentReminders.putValue("ShortDescription", LOCALIZER.msg("description", "Reminds you of programs to not miss them."));
            actionShowCurrentReminders.putValue("ActionId", REMINDER_LIST_ACTION_ID);
            actionShowCurrentReminders.putValue("####KEYBOARD_ACCELERATOR####", ReminderPlugin.getKeyStrokeFrameReminders());
            return new ActionMenu(ReminderPlugin.getName(), (Icon)IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16), new Object[]{actionShowCurrentReminders, action, this.toggleTimer, new ActionMenu(LOCALIZER.msg("pauseForTime", "Pause reminder for time period"), (Icon)IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 16), new Action[]{this.createPauseAction(5), this.createPauseAction(15), this.createPauseAction(30), this.createPauseAction(45), this.createPauseAction(60), this.createPauseAction(90), this.createPauseAction(120), this.createPauseAction(180)})});
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private AbstractAction createPauseAction(final int minutes) {
        AbstractAction pause = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderPlugin.this.startPause(minutes);
            }
        };
        String timeUnit = LOCALIZER.msg("pauseTimerMinutes", "minutes");
        int value = minutes;
        if (minutes % 60 == 0 && minutes != 60) {
            timeUnit = LOCALIZER.msg("pauseTimerHours", "hours");
            value /= 60;
        }
        pause.putValue("Name", LOCALIZER.msg("pauseTimer", "Pause Reminder for {0} {1}", value, timeUnit));
        pause.putValue("ShortDescription", LOCALIZER.msg("pauseTimerDesc", "Pause Reminder for {0} {1} until automatically reactivation", value, timeUnit));
        pause.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 16));
        pause.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("actions", "reminder-stop", 22));
        return pause;
    }

    public static Object playSound(String fileName) {
        try {
            if (StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".mid")) {
                final Sequencer sequencer = MidiSystem.getSequencer();
                sequencer.open();
                final FileInputStream midiFile = new FileInputStream(fileName);
                sequencer.setSequence(MidiSystem.getSequence(midiFile));
                sequencer.start();
                new Thread("Reminder MIDI sequencer"){

                    @Override
                    public void run() {
                        this.setPriority(1);
                        while (sequencer.isRunning()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                        try {
                            sequencer.close();
                            midiFile.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
                return sequencer;
            }
            final AudioInputStream ais = AudioSystem.getAudioInputStream(new File(fileName));
            final AudioFormat format = ais.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (AudioSystem.isLineSupported(info)) {
                final SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format);
                line.start();
                new Thread("Reminder audio playing"){
                    private boolean stopped;

                    @Override
                    public void run() {
                        try {
                            byte[] myData = new byte[1024 * format.getFrameSize()];
                            int numBytesToRead = myData.length;
                            int numBytesRead = 0;
                            int totalToRead = (int)((long)format.getFrameSize() * ais.getFrameLength());
                            this.stopped = false;
                            line.addLineListener(new LineListener(){

                                @Override
                                public void update(LineEvent event) {
                                    if (!(event.getType() == LineEvent.Type.START || line == null || event.getType() != LineEvent.Type.STOP && line.isRunning())) {
                                        stopped = true;
                                        try {
                                            ais.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                            try {
                                for (int total = 0; total < totalToRead && !this.stopped && (numBytesRead = ais.read(myData, 0, numBytesToRead)) != -1; total += numBytesRead) {
                                    line.write(myData, 0, numBytesRead);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (line.isRunning()) {
                                line.drain();
                            }
                            line.stop();
                            if (line != null) {
                                line.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
                return line;
            }
            URL url = new File(fileName).toURI().toURL();
            ReminderPlugin.playAudioClip(url);
        }
        catch (Exception e) {
            if (new File(fileName).isFile()) {
                try {
                    URL url = new File(fileName).toURI().toURL();
                    ReminderPlugin.playAudioClip(url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            String msg = LOCALIZER.msg("error.1", "Error loading reminder sound file!\n({0})", fileName);
            JOptionPane.showMessageDialog(UiUtilities.getBestDialogParent(MainFrame.getInstance()), msg, Localizer.getLocalization("i18n_error"), 0);
        }
        return null;
    }

    protected ActionMenu getContextMenuActions(Program program) {
        return this.getContextMenuActions(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), program);
    }

    public static String getReminderPluginId() {
        return DATAFILE_PREFIX;
    }

    protected ProgramReceiveTarget[] getClientPluginsTargets() {
        ArrayList<ProgramReceiveTarget> list = new ArrayList<ProgramReceiveTarget>();
        for (ProgramReceiveTarget target : this.mClientPluginTargets) {
            ProgramReceiveIf plugin = target.getReceifeIfForIdOfTarget();
            if (plugin == null || !plugin.canReceiveProgramsWithTarget()) continue;
            list.add(target);
        }
        return list.toArray(new ProgramReceiveTarget[list.size()]);
    }

    protected void setClientPluginsTargets(ProgramReceiveTarget[] targets) {
        this.mClientPluginTargets = targets != null ? targets : new ProgramReceiveTarget[0];
    }

    protected int getMarkPriority() {
        if (this.mMarkPriority == -2 && this.mReminderSettings != null) {
            this.mMarkPriority = this.mReminderSettings.getAsInt("markPriority");
            return this.mMarkPriority;
        }
        return this.mMarkPriority;
    }

    protected void setMarkPriority(int priority) {
        ReminderListItem[] items;
        this.mMarkPriority = priority;
        for (ReminderListItem item : items = this.mReminderList.getReminderItems()) {
            item.getProgram().validateMarking();
        }
        this.mReminderSettings.set("markPriority", priority);
        this.saveReminders();
    }

    protected static int getTimeToProgramStart(Program program) {
        int progMinutesAfterMidnight = program.getHours() * 60 + program.getMinutes();
        int remainingMinutes = progMinutesAfterMidnight - IOUtilities.getMinutesAfterMidnight() + 1440 * program.getDate().getNumberOfDaysSince(Date.getCurrentDate());
        if (remainingMinutes < 0) {
            remainingMinutes += 1440;
        }
        if (program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            remainingMinutes = 10081;
        }
        return remainingMinutes;
    }

    protected void handleTvDataUpdateFinished() {
        this.mInfoCreationThread = new Thread(){

            @Override
            public void run() {
                if (ReminderPlugin.this.mReminderSettings.isSet("showRemovedDialog")) {
                    Program[] removedPrograms = ReminderPlugin.this.mReminderList.updatePrograms();
                    ReminderPlugin.this.mInfoPanel = removedPrograms.length > 0 ? new RemovedProgramsPanel(removedPrograms) : null;
                } else {
                    ReminderPlugin.this.mReminderList.updatePrograms();
                    ReminderPlugin.this.mInfoPanel = null;
                }
                ReminderPlugin.this.mHasRightToSave = true;
                ReminderPlugin.this.saveReminders();
                ReminderListDialog.updateReminderList();
                if (ReminderPlugin.this.mReminderListPanel != null) {
                    ReminderPlugin.this.mReminderListPanel.updateTableEntries();
                }
                ReminderPlugin.this.updateRootNode(false);
            }
        };
        this.mInfoCreationThread.start();
    }

    private void showManageRemindersDialog() {
        Window w = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        ReminderListDialog dlg = new ReminderListDialog(w, this.mReminderList);
        int x = this.mReminderSettings.getAsInt("dlgXPos");
        int y = this.mReminderSettings.getAsInt("dlgYPos");
        if (x == -1 || y == -1) {
            UiUtilities.centerAndShow(dlg);
        } else {
            dlg.setLocation(x, y);
            dlg.setVisible(true);
        }
        this.mReminderSettings.set("dlgXPos", dlg.getX());
        this.mReminderSettings.set("dlgYPos", dlg.getY());
        this.mReminderSettings.set("dlgWidth", dlg.getWidth());
        this.mReminderSettings.set("dlgHeight", dlg.getHeight());
    }

    public static void resetLocalizer() {
        LOCALIZER = Localizer.getLocalizerFor(ReminderPlugin.class);
    }

    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return this.mReminderSettings.isSet("provideTab") ? this.mWrapper : null;
    }

    AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        if (this.mInfoCreationThread != null && this.mInfoCreationThread.isAlive()) {
            try {
                this.mInfoCreationThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.mInfoPanel;
    }

    public boolean showDateSeparators() {
        return this.mReminderSettings.isSet("showDateSeparators");
    }

    public void setShowDateSeparators(boolean show) {
        this.mReminderSettings.set("showDateSeparators", show);
        if (this.mReminderListPanel != null) {
            this.mReminderListPanel.installTableModel(false);
        }
    }

    public static int getStartIndexForBeforeReminders(Program program) {
        int remainingMinutes = ReminderPlugin.getTimeToProgramStart(program);
        if (program.isExpired() && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            remainingMinutes = -31;
        } else if (program.isOnAir() && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            remainingMinutes = program.getStartTime() > IOUtilities.getMinutesAfterMidnight() ? program.getStartTime() - 1440 - IOUtilities.getMinutesAfterMidnight() : program.getStartTime() - IOUtilities.getMinutesAfterMidnight();
        }
        int index = 0;
        for (RemindValue value : ReminderConstants.REMIND_AFTER_VALUE_ARR) {
            if (value.getMinutes() >= remainingMinutes || Math.abs(value.getMinutes()) >= program.getLength()) continue;
            ++index;
        }
        return index;
    }

    public static RemindValue[] calculatePossibleReminders(Program program) {
        int remainingMinutes = ReminderPlugin.getTimeToProgramStart(program);
        if (program.isExpired() && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            remainingMinutes = -31;
        } else if (program.isOnAir() && !program.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
            remainingMinutes = program.getStartTime() > IOUtilities.getMinutesAfterMidnight() ? program.getStartTime() - 1440 - IOUtilities.getMinutesAfterMidnight() : program.getStartTime() - IOUtilities.getMinutesAfterMidnight();
        }
        ArrayList<RemindValue> valueList = new ArrayList<RemindValue>();
        for (RemindValue value : ReminderConstants.REMIND_AFTER_VALUE_ARR) {
            if (value.getMinutes() >= remainingMinutes || Math.abs(value.getMinutes()) >= program.getLength()) continue;
            valueList.add(value);
        }
        for (RemindValue value : ReminderConstants.REMIND_BEFORE_VALUE_ARR) {
            if (value.getMinutes() >= remainingMinutes) continue;
            valueList.add(value);
        }
        return valueList.toArray(new RemindValue[valueList.size()]);
    }

    private static void playAudioClip(URL url) {
        try {
            Class<?> clazz = Class.forName("java.applet.AudioClip");
            Method m = Class.forName("java.applet.Applet").getDeclaredMethod("newAudioClip", URL.class);
            m.setAccessible(true);
            Object o = m.invoke(null, url);
            o = clazz.cast(o);
            m = clazz.getMethod("play", new Class[0]);
            m.setAccessible(true);
            m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean hasToSaveSettings() {
        return this.mHasToSaveSettings;
    }

    static {
        DATAFILE_PREFIX = "reminderplugin.ReminderPlugin";
        mRootNode = new PluginTreeNode(LOCALIZER.msg("pluginName", "Reminders"));
    }

    private class ReminderCenterPanel
    extends PluginCenterPanel {
        private ReminderCenterPanel() {
        }

        @Override
        public String getName() {
            return ReminderPlugin.getName();
        }

        @Override
        public JPanel getPanel() {
            return ReminderPlugin.this.mCenterPanel;
        }
    }
}

