/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.search;

import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramSearcher;
import devplugin.ProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import util.io.IOUtilities;
import util.program.ProgramUtilities;

public abstract class AbstractSearcher
implements ProgramSearcher {
    private static Comparator<Program> mStartTimeComparator;
    protected boolean mReplaceSpCh = false;
    private boolean mKeepSearching;
    private ExecutorService mThreadPool;

    private static Comparator<Program> getStartTimeComparator() {
        if (mStartTimeComparator == null) {
            mStartTimeComparator = new Comparator<Program>(){

                @Override
                public int compare(Program prog1, Program prog2) {
                    int dateComp = prog1.getDate().compareTo(prog2.getDate());
                    if (dateComp == 0) {
                        return prog1.getStartTime() - prog2.getStartTime();
                    }
                    return dateComp;
                }
            };
        }
        return mStartTimeComparator;
    }

    @Override
    public boolean matches(Program prog, ProgramFieldType[] fieldArr) {
        if (fieldArr == null) {
            return false;
        }
        try {
            String allFields = this.getProgramFieldsText(prog, fieldArr);
            if (StringUtils.isEmpty((CharSequence)allFields)) {
                return false;
            }
            return this.matches(allFields);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getProgramFieldsText(Program prog, ProgramFieldType[] fieldArr) {
        if (fieldArr.length == 1) {
            ProgramFieldType fieldType = fieldArr[0];
            if (fieldType.getFormat() == 3) {
                return prog.getTextField(fieldType);
            }
            if (fieldType.getFormat() == 4) {
                if (fieldType.equals(ProgramFieldType.EPISODE_NUMBER_TYPE) && prog.hasFieldValue(ProgramFieldType.EPISODE_NUMBER_TYPE)) {
                    return IOUtilities.decodeSingleFieldValueToMultipleEpisodeString(prog.getIntField(fieldType));
                }
                return prog.getIntFieldAsString(fieldType);
            }
            if (fieldType.getFormat() == 5) {
                if (fieldType == ProgramFieldType.START_TIME_TYPE) {
                    return prog.getTimeString();
                }
                if (fieldType == ProgramFieldType.END_TIME_TYPE) {
                    return prog.getEndTimeString();
                }
                return prog.getTimeFieldAsString(fieldType);
            }
        }
        StringBuilder buffer = new StringBuilder();
        for (ProgramFieldType fieldType : fieldArr) {
            String value = null;
            if (fieldType != null) {
                if (fieldType.getFormat() == 3) {
                    value = prog.getTextField(fieldType);
                } else if (fieldType.getFormat() == 4) {
                    value = fieldType.equals(ProgramFieldType.EPISODE_NUMBER_TYPE) && prog.hasFieldValue(ProgramFieldType.EPISODE_NUMBER_TYPE) ? IOUtilities.decodeSingleFieldValueToMultipleEpisodeString(prog.getIntField(fieldType)) : prog.getIntFieldAsString(fieldType);
                } else if (fieldType.getFormat() == 5) {
                    value = fieldType == ProgramFieldType.START_TIME_TYPE ? prog.getTimeString() : (fieldType == ProgramFieldType.END_TIME_TYPE ? prog.getEndTimeString() : prog.getTimeFieldAsString(fieldType));
                }
            }
            if (value == null) continue;
            buffer.append(value).append(' ');
        }
        String result = buffer.toString();
        if (this.mReplaceSpCh) {
            result = result.replaceAll("\\p{Punct}", ";");
        }
        result = result.replace('\n', ' ');
        return result.trim();
    }

    @Override
    public synchronized Program[] search(ProgramFieldType[] fieldArr, Date startDate, int nrDays, Channel[] channels, boolean sortByStartTime, ProgressMonitor progress) {
        return this.search(fieldArr, startDate, nrDays, channels, sortByStartTime, progress, null);
    }

    @Override
    @Deprecated(since="4.2.3")
    public synchronized Program[] search(ProgramFieldType[] fieldArr, Date startDate, int nrDays, Channel[] channels, boolean sortByStartTime, ProgressMonitor progress, DefaultListModel<Object> listModel) {
        this.mKeepSearching = true;
        if (channels == null) {
            channels = Settings.Channels.SUBSCRIBED.getChannelArray();
        }
        if (nrDays < 0) {
            startDate = Date.getCurrentDate().addDays(-1);
            nrDays = TvDataBase.getInstance().getMaxSupportedDate().getNumberOfDaysSince(startDate);
        }
        ArrayList<Program> hitList = new ArrayList<Program>();
        int lastDayWithData = 0;
        if (progress != null) {
            progress.setMaximum(channels.length * (nrDays + 1));
        }
        for (int day = 0; day <= nrDays && this.mKeepSearching; ++day) {
            for (int channelIdx = 0; channelIdx < channels.length && this.mKeepSearching; ++channelIdx) {
                ChannelDayProgram dayProg;
                Channel channel;
                if (progress != null) {
                    progress.setValue(day * channels.length + channelIdx);
                }
                if ((channel = channels[channelIdx]) == null || (dayProg = TvDataBase.getInstance().getDayProgram(startDate, channel)) == null) continue;
                lastDayWithData = day;
                for (int i = 0; i < dayProg.getProgramCount() && this.mKeepSearching; ++i) {
                    Program prog = dayProg.getProgramAt(i);
                    if (!this.matches(prog, fieldArr)) continue;
                    if (listModel != null) {
                        SwingUtilities.invokeLater(() -> {
                            if (this.mKeepSearching) {
                                int insertIndex = 0;
                                for (int index = 0; index < listModel.getSize(); ++index) {
                                    Program p = (Program)listModel.get(index);
                                    if (ProgramUtilities.getProgramComparator().compare(p, prog) >= 0) continue;
                                    insertIndex = index + 1;
                                }
                                listModel.add(insertIndex, prog);
                            }
                        });
                    }
                    hitList.add(prog);
                }
            }
            if (day - lastDayWithData > 10) break;
            startDate = startDate.addDays(1);
        }
        Program[] hitArr = new Program[hitList.size()];
        hitList.toArray(hitArr);
        if (sortByStartTime) {
            Arrays.sort(hitArr, AbstractSearcher.getStartTimeComparator());
        }
        if (progress != null) {
            progress.setValue(0);
            progress.setMessage("");
        }
        return hitArr;
    }

    @Override
    public Program[] search(ProgramFieldType[] fieldArr, Date startDate, int nrDays, Channel[] channels, boolean sortByStartTime, DefaultListModel<Program> listModel, ProgressMonitor progress) {
        this.mKeepSearching = true;
        if (channels == null) {
            channels = Settings.Channels.SUBSCRIBED.getChannelArray();
        }
        if (nrDays < 0) {
            startDate = Date.getCurrentDate().addDays(-1);
            nrDays = TvDataBase.getInstance().getMaxSupportedDate().getNumberOfDaysSince(startDate);
        }
        ArrayList<Program> hitList = new ArrayList<Program>();
        int lastDayWithData = 0;
        if (progress != null) {
            progress.setMaximum(channels.length * (nrDays + 1));
        }
        for (int day = 0; day <= nrDays && this.mKeepSearching; ++day) {
            for (int channelIdx = 0; channelIdx < channels.length && this.mKeepSearching; ++channelIdx) {
                ChannelDayProgram dayProg;
                Channel channel;
                if (progress != null) {
                    progress.setValue(day * channels.length + channelIdx);
                }
                if ((channel = channels[channelIdx]) == null || (dayProg = TvDataBase.getInstance().getDayProgram(startDate, channel)) == null) continue;
                lastDayWithData = day;
                for (int i = 0; i < dayProg.getProgramCount() && this.mKeepSearching; ++i) {
                    Program prog = dayProg.getProgramAt(i);
                    if (!this.matches(prog, fieldArr)) continue;
                    if (listModel != null) {
                        SwingUtilities.invokeLater(() -> {
                            if (this.mKeepSearching) {
                                int insertIndex = 0;
                                for (int index = 0; index < listModel.getSize(); ++index) {
                                    Program p = (Program)listModel.get(index);
                                    if (ProgramUtilities.getProgramComparator().compare(p, prog) >= 0) continue;
                                    insertIndex = index + 1;
                                }
                                listModel.add(insertIndex, prog);
                            }
                        });
                    }
                    hitList.add(prog);
                }
            }
            if (day - lastDayWithData > 10) break;
            startDate = startDate.addDays(1);
        }
        Program[] hitArr = new Program[hitList.size()];
        hitList.toArray(hitArr);
        if (sortByStartTime) {
            Arrays.sort(hitArr, AbstractSearcher.getStartTimeComparator());
        }
        if (progress != null) {
            progress.setValue(0);
            progress.setMessage("");
        }
        return hitArr;
    }

    @Override
    public synchronized Program[] search(ProgramFieldType[] fieldArr, Date startDate, int nrDays, Channel[] channels, boolean sortByStartTime) {
        return this.search(fieldArr, startDate, nrDays, channels, sortByStartTime, null);
    }

    protected abstract boolean matches(String var1);

    @Override
    public void stopSearch() {
        this.mKeepSearching = false;
        if (this.mThreadPool != null && !this.mThreadPool.isTerminated()) {
            this.mThreadPool.shutdownNow();
        }
    }
}

