/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import util.io.IOUtilities;

public class ThemeDownloadItem
implements Comparable<ThemeDownloadItem> {
    public static final String NAME_EN = "name.en";
    public static final String NAME_DE = "name.de";
    public static final String DESCRIPTION_EN = "desc.en";
    public static final String DESCRIPTION_DE = "desc.de";
    public static final String PREVIEW_IMAGE = "preview";
    public static final String DOWNLOAD_URL = "download";
    public static final String AUTHOR = "author";
    private Properties mProperties = new Properties();
    private String mID;

    public ThemeDownloadItem(String id) {
        this.mID = id;
    }

    public void addProperty(String key, String value) {
        this.mProperties.setProperty(key, value);
    }

    public String getName(Locale lang) {
        String name = null;
        if (lang != null && lang.equals(Locale.GERMAN)) {
            name = this.mProperties.getProperty(NAME_DE, this.mProperties.getProperty(NAME_EN, this.mID));
        }
        if (name == null) {
            name = this.mProperties.getProperty(NAME_EN, this.mID);
        }
        return name;
    }

    public String getDescription(Locale lang) {
        String description = null;
        if (lang != null && lang.equals(Locale.GERMAN)) {
            description = this.mProperties.getProperty(DESCRIPTION_DE, this.mProperties.getProperty(DESCRIPTION_EN, null));
        }
        if (description == null) {
            description = this.mProperties.getProperty(DESCRIPTION_EN, null);
        }
        return description;
    }

    public ImageIcon getPreviewImage() {
        String url = this.mProperties.getProperty(PREVIEW_IMAGE, null);
        if (url != null) {
            try {
                byte[] image = IOUtilities.loadFileFromHttpServer(new URL(url));
                return new ImageIcon(image);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getAuthor() {
        return this.mProperties.getProperty(AUTHOR, "Unknown");
    }

    public boolean download(File iconDir) {
        String url;
        if (!iconDir.isDirectory()) {
            iconDir.mkdirs();
        }
        if (iconDir.isDirectory() && (url = this.mProperties.getProperty(DOWNLOAD_URL, null)) != null) {
            File targetFile = new File(iconDir, url.substring(url.lastIndexOf("=") + 1) + ".zip");
            try {
                IOUtilities.download(new URL(url), targetFile);
                return targetFile.isFile();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String toString() {
        return this.mID;
    }

    @Override
    public int compareTo(ThemeDownloadItem o) {
        return this.getName(Locale.getDefault()).compareToIgnoreCase(o.getName(Locale.getDefault()));
    }
}

