/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import devplugin.ProgramInfoHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class ProgramInfoFilterComponent
extends AbstractFilterComponent {
    private SelectableItemList<String> mList;
    private int mSelectedBits = 0;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramInfoFilterComponent.class);

    public ProgramInfoFilterComponent() {
        this("", "");
    }

    public ProgramInfoFilterComponent(String name, String description) {
        super(name, description);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        int info = program.getInfo();
        if (info < 1) {
            return false;
        }
        return this.bitSet(info, this.mSelectedBits);
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mSelectedBits = in.readInt();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mSelectedBits);
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel centerPanel = new JPanel((LayoutManager)new FormLayout("50dlu:grow", "default,fill:default:grow"));
        String[] infoMessages = ProgramInfoHelper.getInfoIconMessages();
        int[] infoBits = ProgramInfoHelper.getInfoBits();
        String[] allItems = new String[infoMessages.length];
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (int i = 0; i < infoMessages.length; ++i) {
            String item;
            allItems[i] = item = infoMessages[i];
            if (!this.bitSet(this.mSelectedBits, infoBits[i])) continue;
            selectedItems.add(item);
        }
        this.mList = new SelectableItemList<String>(selectedItems.toArray(new String[selectedItems.size()]), allItems);
        this.mList.addCenterRendererComponent(String.class, new SelectableItemRendererCenterComponentIf<String>(){

            @Override
            public JPanel createCenterPanel(JList<? extends SelectableItem<String>> list, String value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                JLabel label = new JLabel();
                label.setHorizontalAlignment(10);
                label.setVerticalAlignment(0);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "West");
                label.setIcon(ProgramInfoHelper.getInfoIcons()[index]);
                label.setText(value);
                if (isSelected && isEnabled) {
                    panel.setOpaque(true);
                    label.setForeground(list.getSelectionForeground());
                    panel.setBackground(list.getSelectionBackground());
                } else {
                    panel.setOpaque(false);
                    label.setForeground(list.getForeground());
                    panel.setBackground(list.getBackground());
                }
                return panel;
            }

            @Override
            public void calculateSize(JList<? extends SelectableItem<String>> list, int index, JPanel contentPane) {
            }
        });
        centerPanel.add(this.mList, CC.xy((int)1, (int)2));
        centerPanel.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "ATTENTION: The list items are conjunctions so if you select two or more items that are contradictions no program will be accepted. (For example, a program cannot be mono and stereo at the same time.)")), CC.xy((int)1, (int)1));
        return centerPanel;
    }

    @Override
    public void saveSettings() {
        int bits = 0;
        String[] infoMessages = ProgramInfoHelper.getInfoIconMessages();
        int[] infoBits = ProgramInfoHelper.getInfoBits();
        List<String> checked = this.mList.getSelectionList();
        block0: for (String item : checked) {
            for (int infoIndex = 0; infoIndex < infoMessages.length; ++infoIndex) {
                if (!item.equals(infoMessages[infoIndex])) continue;
                bits |= infoBits[infoIndex];
                continue block0;
            }
        }
        this.mSelectedBits = bits;
    }

    public String toString() {
        return mLocalizer.msg("ProgrammInfo", "Program-Info");
    }

    private boolean bitSet(int num, int pattern) {
        return (num & pattern) == pattern;
    }
}

