/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Queue"})
public class Queue
extends RubyObject {
    private LinkedList entries = new LinkedList();
    protected volatile int numWaiting = 0;

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Queue result2 = new Queue(context.runtime, (RubyClass)recv2);
        result2.callInit(context, args2, block);
        return result2;
    }

    public Queue(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static void setup(Ruby runtime) {
        RubyClass cQueue = runtime.defineClass("Queue", runtime.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Queue(runtime, klass);
            }
        });
        cQueue.setReifiedClass(Queue.class);
        cQueue.defineAnnotatedMethods(Queue.class);
    }

    @JRubyMethod(name={"shutdown!"})
    public synchronized IRubyObject shutdown(ThreadContext context) {
        this.entries = null;
        this.notifyAll();
        return context.runtime.getNil();
    }

    public synchronized void shutdown() {
        this.entries = null;
        this.notifyAll();
    }

    public boolean isShutdown() {
        return this.entries == null;
    }

    public synchronized void checkShutdown(ThreadContext context) {
        if (this.entries == null) {
            throw new RaiseException(context.runtime, context.runtime.getThreadError(), "queue shut down", false);
        }
    }

    @JRubyMethod
    public synchronized IRubyObject clear(ThreadContext context) {
        this.checkShutdown(context);
        this.entries.clear();
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"empty?"})
    public synchronized RubyBoolean empty_p(ThreadContext context) {
        this.checkShutdown(context);
        return context.runtime.newBoolean(this.entries.size() == 0);
    }

    @JRubyMethod(name={"length", "size"})
    public synchronized RubyNumeric length(ThreadContext context) {
        this.checkShutdown(context);
        return RubyNumeric.int2fix(context.runtime, this.entries.size());
    }

    protected synchronized long java_length() {
        return this.entries.size();
    }

    @JRubyMethod
    public RubyNumeric num_waiting(ThreadContext context) {
        return context.runtime.newFixnum(this.numWaiting);
    }

    @JRubyMethod(name={"pop", "deq", "shift"})
    public synchronized IRubyObject pop(ThreadContext context) {
        return this.pop(context, true);
    }

    @JRubyMethod(name={"pop", "deq", "shift"})
    public synchronized IRubyObject pop(ThreadContext context, IRubyObject arg0) {
        return this.pop(context, !arg0.isTrue());
    }

    @JRubyMethod(name={"push", "<<", "enq"})
    public synchronized IRubyObject push(ThreadContext context, IRubyObject value2) {
        this.checkShutdown(context);
        this.entries.addLast(value2);
        this.notify();
        return context.runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IRubyObject pop(ThreadContext context, boolean should_block) {
        this.checkShutdown(context);
        if (!should_block && this.entries.size() == 0) {
            throw new RaiseException(context.runtime, context.runtime.getThreadError(), "queue empty", false);
        }
        ++this.numWaiting;
        try {
            while (this.java_length() == 0L) {
                try {
                    context.getThread().wait_timeout(this, null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkShutdown(context);
            }
        }
        finally {
            --this.numWaiting;
        }
        return (IRubyObject)this.entries.removeFirst();
    }
}

