/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.lib.Config;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private long blockLimit;
    private int blockSize;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long newLimit) {
        this.blockLimit = newLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int newSize) {
        this.blockSize = Math.max(512, newSize);
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config rc) {
        this.setBlockLimit(rc.getLong("core", "dfs", "blockLimit", this.getBlockLimit()));
        this.setBlockSize(rc.getInt("core", "dfs", "blockSize", this.getBlockSize()));
        return this;
    }
}

