/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.ApplyResult;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.PatchApplyException;
import org.eclipse.jgit.api.errors.PatchFormatException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    ApplyCommand(Repository repo) {
        super(repo);
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplyResult call() throws GitAPIException, PatchFormatException, PatchApplyException {
        this.checkCallable();
        ApplyResult r = new ApplyResult();
        try {
            Patch p = new Patch();
            try {
                p.parse(this.in);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.in.close();
                throw throwable;
            }
            this.in.close();
            if (!p.getErrors().isEmpty()) {
                throw new PatchFormatException(p.getErrors());
            }
            for (FileHeader fileHeader : p.getFiles()) {
                DiffEntry.ChangeType type = fileHeader.getChangeType();
                File f = null;
                switch (type) {
                    case ADD: {
                        f = this.getFile(fileHeader.getNewPath(), true);
                        this.apply(f, fileHeader);
                        break;
                    }
                    case MODIFY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        this.apply(f, fileHeader);
                        break;
                    }
                    case DELETE: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        if (f.delete()) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, f));
                    }
                    case RENAME: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File dest = this.getFile(fileHeader.getNewPath(), false);
                        if (f.renameTo(dest)) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().renameFileFailed, f, dest));
                    }
                    case COPY: {
                        Object var11_15;
                        f = this.getFile(fileHeader.getOldPath(), false);
                        byte[] bs = IO.readFully(f);
                        FileOutputStream fos = new FileOutputStream(this.getFile(fileHeader.getNewPath(), true));
                        try {
                            fos.write(bs);
                            var11_15 = null;
                        }
                        catch (Throwable throwable) {
                            var11_15 = null;
                            fos.close();
                            throw throwable;
                        }
                        fos.close();
                        break;
                    }
                }
                r.addUpdatedFile(f);
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage()), e);
        }
        this.setCallable(false);
        return r;
    }

    private File getFile(String path, boolean create) throws PatchApplyException {
        File f = new File(this.getRepository().getWorkTree(), path);
        if (create) {
            try {
                File parent = f.getParentFile();
                FileUtils.mkdirs(parent, true);
                FileUtils.createNewFile(f);
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().createNewFileFailed, f), e);
            }
        }
        return f;
    }

    private void apply(File f, FileHeader fh) throws IOException, PatchApplyException {
        RawText rt = new RawText(f);
        ArrayList<String> oldLines = new ArrayList<String>(rt.size());
        for (int i = 0; i < rt.size(); ++i) {
            oldLines.add(rt.getString(i));
        }
        ArrayList<String> newLines = new ArrayList<String>(oldLines);
        for (HunkHeader hunkHeader : fh.getHunks()) {
            StringBuilder hunk = new StringBuilder();
            for (int j = hunkHeader.getStartOffset(); j < hunkHeader.getEndOffset(); ++j) {
                hunk.append((char)hunkHeader.getBuffer()[j]);
            }
            RawText hrt = new RawText(hunk.toString().getBytes());
            ArrayList<String> hunkLines = new ArrayList<String>(hrt.size());
            for (int i = 0; i < hrt.size(); ++i) {
                hunkLines.add(hrt.getString(i));
            }
            int pos = 0;
            block9: for (int j = 1; j < hunkLines.size(); ++j) {
                String hunkLine = (String)hunkLines.get(j);
                switch (hunkLine.charAt(0)) {
                    case ' ': {
                        if (!((String)newLines.get(hunkHeader.getNewStartLine() - 1 + pos)).equals(hunkLine.substring(1))) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                        }
                        ++pos;
                        continue block9;
                    }
                    case '-': {
                        if (!((String)newLines.get(hunkHeader.getNewStartLine() - 1 + pos)).equals(hunkLine.substring(1))) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
                        }
                        newLines.remove(hunkHeader.getNewStartLine() - 1 + pos);
                        continue block9;
                    }
                    case '+': {
                        newLines.add(hunkHeader.getNewStartLine() - 1 + pos, hunkLine.substring(1));
                        ++pos;
                    }
                }
            }
        }
        if (!this.isNoNewlineAtEndOfFile(fh)) {
            newLines.add("");
        }
        if (!rt.isMissingNewlineAtEnd()) {
            oldLines.add("");
        }
        if (!ApplyCommand.isChanged(oldLines, newLines)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String l : newLines) {
            sb.append(l).append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        FileWriter fileWriter = new FileWriter(f);
        fileWriter.write(sb.toString());
        fileWriter.close();
    }

    private static boolean isChanged(List<String> ol, List<String> nl) {
        if (ol.size() != nl.size()) {
            return true;
        }
        for (int i = 0; i < ol.size(); ++i) {
            if (ol.get(i).equals(nl.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fh) {
        HunkHeader lastHunk = fh.getHunks().get(fh.getHunks().size() - 1);
        RawText lhrt = new RawText(lastHunk.getBuffer());
        return lhrt.getString(lhrt.size() - 1).equals("\\ No newline at end of file");
    }
}

