/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graylog.plugins.views.search.LegacyDecoratorProcessor;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.text.Text;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.joda.time.DateTime;

public class ESMessageList
implements ESSearchTypeHandler<MessageList> {
    private final QueryStringDecorators esQueryDecorators;
    private final LegacyDecoratorProcessor decoratorProcessor;
    private final boolean allowHighlighting;

    @Inject
    public ESMessageList(QueryStringDecorators esQueryDecorators, LegacyDecoratorProcessor decoratorProcessor, @Named(value="allow_highlighting") boolean allowHighlighting) {
        this.esQueryDecorators = esQueryDecorators;
        this.decoratorProcessor = decoratorProcessor;
        this.allowHighlighting = allowHighlighting;
    }

    @VisibleForTesting
    public ESMessageList(QueryStringDecorators esQueryDecorators) {
        this(esQueryDecorators, (LegacyDecoratorProcessor)new LegacyDecoratorProcessor.Fake(), false);
    }

    private static ResultMessage resultMessageFromSearchHit(SearchHit hit) {
        Map<String, List> highlights = hit.getHighlightFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ESMessageList::highlightsFromFragments));
        return ResultMessage.parseFromSource((String)hit.getId(), (String)hit.getIndex(), hit.getSourceAsMap(), highlights);
    }

    private static List<String> highlightsFromFragments(Map.Entry<String, HighlightField> entry) {
        return Arrays.stream(entry.getValue().fragments()).map(Text::toString).collect(Collectors.toList());
    }

    public void doGenerateQueryPart(SearchJob job, Query query, MessageList messageList, ESGeneratedQueryContext queryContext) {
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder((SearchType)messageList).size(messageList.limit()).from(messageList.offset());
        this.applyHighlightingIfActivated(searchSourceBuilder, job, query);
        Set effectiveStreamIds = messageList.effectiveStreams().isEmpty() ? query.usedStreamIds() : messageList.effectiveStreams();
        List sorts = (List)MoreObjects.firstNonNull((Object)messageList.sort(), Collections.singletonList(Sort.create((String)"timestamp", (Sort.Order)Sort.Order.DESC)));
        sorts.forEach(sort -> {
            FieldSortBuilder fieldSort = (FieldSortBuilder)SortBuilders.fieldSort(sort.field()).order(this.toSortOrder(sort.order()));
            Optional<String> fieldType = queryContext.fieldType(effectiveStreamIds, sort.field());
            searchSourceBuilder.sort(fieldType.map(fieldSort::unmappedType).orElse(fieldSort));
        });
    }

    private SortOrder toSortOrder(Sort.Order sortOrder) {
        switch (sortOrder) {
            case ASC: {
                return SortOrder.ASC;
            }
            case DESC: {
                return SortOrder.DESC;
            }
        }
        throw new IllegalStateException("Invalid sort order: " + sortOrder);
    }

    private void applyHighlightingIfActivated(SearchSourceBuilder searchSourceBuilder, SearchJob job, Query query) {
        if (!this.allowHighlighting) {
            return;
        }
        QueryStringQueryBuilder highlightQuery = this.decoratedHighlightQuery(job, query);
        searchSourceBuilder.highlighter((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(false)).highlightQuery(highlightQuery)).field("*").fragmentSize(0)).numOfFragments(0));
    }

    private QueryStringQueryBuilder decoratedHighlightQuery(SearchJob job, Query query) {
        String raw = ((ElasticsearchQueryString)query.query()).queryString();
        String decorated = this.esQueryDecorators.decorate(raw, job, query, Collections.emptySet());
        return QueryBuilders.queryStringQuery(decorated);
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, MessageList searchType, SearchResponse result, Aggregations aggregations, ESGeneratedQueryContext queryContext) {
        List messages = StreamSupport.stream(result.getHits().spliterator(), false).map(ESMessageList::resultMessageFromSearchHit).map(resultMessage -> ResultMessageSummary.create((Multimap)resultMessage.highlightRanges, (Map)resultMessage.getMessage().getFields(), (String)resultMessage.getIndex())).collect(Collectors.toList());
        String undecoratedQueryString = ((ElasticsearchQueryString)query.query()).queryString();
        String queryString = this.esQueryDecorators.decorate(undecoratedQueryString, job, query, Collections.emptySet());
        DateTime from = query.effectiveTimeRange((SearchType)searchType).getFrom();
        DateTime to = query.effectiveTimeRange((SearchType)searchType).getTo();
        org.graylog2.rest.resources.search.responses.SearchResponse searchResponse = org.graylog2.rest.resources.search.responses.SearchResponse.create((String)undecoratedQueryString, (String)queryString, Collections.emptySet(), messages, Collections.emptySet(), (long)0L, (long)result.getHits().getTotalHits().value, (DateTime)from, (DateTime)to);
        org.graylog2.rest.resources.search.responses.SearchResponse decoratedSearchResponse = this.decoratorProcessor.decorateSearchResponse(searchResponse, searchType.decorators());
        MessageList.Result.Builder resultBuilder = MessageList.Result.result((String)searchType.id()).messages(decoratedSearchResponse.messages()).effectiveTimerange(AbsoluteRange.create((DateTime)from, (DateTime)to)).totalResults(decoratedSearchResponse.totalResults());
        return searchType.name().map(arg_0 -> ((MessageList.Result.Builder)resultBuilder).name(arg_0)).orElse(resultBuilder).build();
    }
}

