/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog.storage.elasticsearch7.Scroll;
import org.graylog.storage.elasticsearch7.SearchRequestFactory;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.ScrollCommand;
import org.graylog2.indexer.searches.SearchesAdapter;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class SearchesAdapterES7
implements SearchesAdapter {
    private static final String AGG_CARDINALITY = "gl2_field_cardinality";
    private static final String AGG_EXTENDED_STATS = "gl2_extended_stats";
    private static final String AGG_VALUE_COUNT = "gl2_value_count";
    private final ElasticsearchClient client;
    private final Scroll scroll;
    private final SearchRequestFactory searchRequestFactory;

    @Inject
    public SearchesAdapterES7(ElasticsearchClient client, Scroll scroll, SearchRequestFactory searchRequestFactory) {
        this.client = client;
        this.scroll = scroll;
        this.searchRequestFactory = searchRequestFactory;
    }

    public CountResult count(Set<String> affectedIndices, String query, TimeRange range, String filter) {
        SearchesConfig config = SearchesConfig.builder().query(query).range(range).filter(filter).limit(0).offset(0).build();
        SearchSourceBuilder searchSourceBuilder = this.searchRequestFactory.create(config);
        SearchRequest searchRequest = new SearchRequest(affectedIndices.toArray(new String[0])).source(searchSourceBuilder);
        SearchResponse result = this.client.search(searchRequest, "Fetching message count failed for indices ");
        return CountResult.create((long)result.getHits().getTotalHits().value, (long)result.getTook().getMillis());
    }

    public ScrollResult scroll(Set<String> indexWildcards, Sorting sorting, String filter, String query, TimeRange range, int limit, int offset, List<String> fields) {
        return this.scroll(ScrollCommand.builder().indices(indexWildcards).sorting(sorting).filter(filter).query(query).range(range).limit(limit).offset(offset).fields(fields).build());
    }

    public ScrollResult scroll(Set<String> indexWildcards, Sorting sorting, String filter, String query, int batchSize) {
        return this.scroll(ScrollCommand.builder().indices(indexWildcards).sorting(sorting).filter(filter).query(query).batchSize(batchSize).build());
    }

    public ScrollResult scroll(ScrollCommand scrollCommand) {
        return this.scroll.scroll(scrollCommand);
    }

    public SearchResult search(Set<String> indices, Set<IndexRange> indexRanges, SearchesConfig config) {
        SearchSourceBuilder searchSourceBuilder = this.searchRequestFactory.create(config);
        if (indexRanges.isEmpty()) {
            return SearchResult.empty((String)config.query(), (String)searchSourceBuilder.toString());
        }
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[0])).source(searchSourceBuilder);
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to perform search query");
        List<ResultMessage> resultMessages = this.extractResultMessages(searchResult);
        long totalResults = searchResult.getHits().getTotalHits().value;
        long tookMs = searchResult.getTook().getMillis();
        String builtQuery = searchSourceBuilder.toString();
        return new SearchResult(resultMessages, totalResults, indexRanges, config.query(), builtQuery, tookMs);
    }

    private List<ResultMessage> extractResultMessages(SearchResponse searchResult) {
        return Streams.stream((Iterable)searchResult.getHits()).map(hit -> ResultMessage.parseFromSource((String)hit.getId(), (String)hit.getIndex(), hit.getSourceAsMap())).collect(Collectors.toList());
    }

    public FieldStatsResult fieldStats(String query, String filter, TimeRange range, Set<String> indices, String field, boolean includeCardinality, boolean includeStats, boolean includeCount) {
        SearchesConfig config = SearchesConfig.builder().query(query).filter(filter).range(range).offset(0).limit(-1).build();
        SearchSourceBuilder searchSourceBuilder = this.searchRequestFactory.create(config);
        if (includeCount) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.count(AGG_VALUE_COUNT).field(field));
        }
        if (includeStats) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.extendedStats(AGG_EXTENDED_STATS).field(field));
        }
        if (includeCardinality) {
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.cardinality(AGG_CARDINALITY).field(field));
        }
        if (indices.isEmpty()) {
            return FieldStatsResult.empty((String)query, (String)searchSourceBuilder.toString());
        }
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[0])).source(searchSourceBuilder);
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to retrieve fields stats");
        List<ResultMessage> resultMessages = this.extractResultMessages(searchResult);
        long tookMs = searchResult.getTook().getMillis();
        ExtendedStats extendedStatsAggregation = (ExtendedStats)searchResult.getAggregations().get(AGG_EXTENDED_STATS);
        ValueCount valueCountAggregation = (ValueCount)searchResult.getAggregations().get(AGG_VALUE_COUNT);
        Cardinality cardinalityAggregation = (Cardinality)searchResult.getAggregations().get(AGG_CARDINALITY);
        return this.createFieldStatsResult(extendedStatsAggregation, valueCountAggregation, cardinalityAggregation, resultMessages, query, searchSourceBuilder.toString(), tookMs);
    }

    private FieldStatsResult createFieldStatsResult(ExtendedStats extendedStatsAggregation, ValueCount valueCountAggregation, Cardinality cardinalityAggregation, List<ResultMessage> resultMessages, String query, String builtQuery, long tookMs) {
        long cardinality = cardinalityAggregation == null ? Long.MIN_VALUE : cardinalityAggregation.getValue();
        long count = valueCountAggregation == null ? Long.MIN_VALUE : valueCountAggregation.getValue();
        double sum = Double.NaN;
        double sumOfSquares = Double.NaN;
        double mean = Double.NaN;
        double min = Double.NaN;
        double max = Double.NaN;
        double variance = Double.NaN;
        double stdDeviation = Double.NaN;
        if (extendedStatsAggregation != null) {
            sum = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getSum(), (Object)Double.NaN);
            sumOfSquares = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getSumOfSquares(), (Object)Double.NaN);
            mean = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getAvg(), (Object)Double.NaN);
            min = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getMin(), (Object)Double.NaN);
            max = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getMax(), (Object)Double.NaN);
            variance = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getVariance(), (Object)Double.NaN);
            stdDeviation = (Double)MoreObjects.firstNonNull((Object)extendedStatsAggregation.getStdDeviation(), (Object)Double.NaN);
        }
        return FieldStatsResult.create((long)count, (double)sum, (double)sumOfSquares, (double)mean, (double)min, (double)max, (double)variance, (double)stdDeviation, (long)cardinality, resultMessages, (String)query, (String)builtQuery, (long)tookMs);
    }
}

