/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.apache.http.Header;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpException;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpResponse;
import org.graylog.shaded.elasticsearch7.org.apache.http.HttpResponseInterceptor;
import org.graylog.shaded.elasticsearch7.org.apache.http.protocol.HttpContext;

public class ElasticsearchFilterDeprecationWarningsInterceptor
implements HttpResponseInterceptor {
    private String[] messagesToFilter = new String[]{"setting was deprecated in Elasticsearch", "but in a future major version, directaccess to system indices and their aliases will not be allowed", "in epoch time formats is deprecated and will not be supported in the next major version of Elasticsearch", "Use new java.time date format specifiers."};

    private boolean isDeprecationMessage(String message) {
        for (String msg : this.messagesToFilter) {
            if (!message.contains(msg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        List warnings = Arrays.stream(response.getHeaders("Warning")).filter(header -> !this.isDeprecationMessage(header.getValue())).collect(Collectors.toList());
        response.removeHeaders("Warning");
        warnings.stream().forEach(header -> response.addHeader((Header)header));
    }
}

