/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.translog;

import java.nio.file.Path;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeUnit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;

public final class TranslogConfig {
    public static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(8L, ByteSizeUnit.KB);
    private final BigArrays bigArrays;
    private final IndexSettings indexSettings;
    private final ShardId shardId;
    private final Path translogPath;
    private final ByteSizeValue bufferSize;

    public TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays) {
        this(shardId, translogPath, indexSettings, bigArrays, DEFAULT_BUFFER_SIZE);
    }

    TranslogConfig(ShardId shardId, Path translogPath, IndexSettings indexSettings, BigArrays bigArrays, ByteSizeValue bufferSize) {
        this.bufferSize = bufferSize;
        this.indexSettings = indexSettings;
        this.shardId = shardId;
        this.translogPath = translogPath;
        this.bigArrays = bigArrays;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public Path getTranslogPath() {
        return this.translogPath;
    }

    public ByteSizeValue getBufferSize() {
        return this.bufferSize;
    }
}

