/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ContentPath;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.StringFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    private final boolean required;

    private RoutingFieldMapper(FieldType fieldType, boolean required) {
        super(fieldType, RoutingFieldType.INSTANCE);
        this.required = required;
    }

    public boolean required() {
        return this.required;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String routing = context.sourceToParse().routing();
        if (routing != null && (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored())) {
            context.doc().add(new Field(this.fieldType().name(), routing, (IndexableFieldType)this.fieldType));
            this.createFieldNamesField(context);
        }
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && !this.required) {
            return builder;
        }
        builder.startObject("_routing");
        if (includeDefaults || this.required) {
            builder.field("required", this.required);
        }
        builder.endObject();
        return builder;
    }

    static final class RoutingFieldType
    extends StringFieldType {
        static RoutingFieldType INSTANCE = new RoutingFieldType();

        private RoutingFieldType() {
            super("_routing", true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        @Override
        public String typeName() {
            return "_routing";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_field_names", this.name()));
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("required")) continue;
                builder.required(XContentMapValues.nodeBooleanValue(fieldNode, name + ".required"));
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new RoutingFieldMapper(Defaults.FIELD_TYPE, false);
            }
            return ((MetadataFieldMapper.Builder)this.parse("_routing", Collections.emptyMap(), context)).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder> {
        private boolean required = false;

        public Builder() {
            super("_routing", Defaults.FIELD_TYPE);
        }

        public Builder required(boolean required) {
            this.required = required;
            return (Builder)this.builder;
        }

        @Override
        public RoutingFieldMapper build(Mapper.BuilderContext context) {
            return new RoutingFieldMapper(this.fieldType, this.required);
        }
    }

    public static class Defaults {
        public static final String NAME = "_routing";
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean REQUIRED = false;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

