/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.CharArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public final class CreateTokenRequest
implements Validatable,
ToXContentObject {
    private final String grantType;
    private final String scope;
    private final String username;
    private final char[] password;
    private final String refreshToken;
    private final char[] kerberosTicket;

    public CreateTokenRequest(String grantType, @Nullable String scope, @Nullable String username, @Nullable char[] password, @Nullable String refreshToken, @Nullable char[] kerberosTicket) {
        if (Strings.isNullOrEmpty(grantType)) {
            throw new IllegalArgumentException("grant_type is required");
        }
        this.grantType = grantType;
        this.username = username;
        this.password = password;
        this.scope = scope;
        this.refreshToken = refreshToken;
        this.kerberosTicket = kerberosTicket;
    }

    public static CreateTokenRequest passwordGrant(String username, char[] password) {
        if (Strings.isNullOrEmpty(username)) {
            throw new IllegalArgumentException("username is required");
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("password is required");
        }
        return new CreateTokenRequest("password", null, username, password, null, null);
    }

    public static CreateTokenRequest refreshTokenGrant(String refreshToken) {
        if (Strings.isNullOrEmpty(refreshToken)) {
            throw new IllegalArgumentException("refresh_token is required");
        }
        return new CreateTokenRequest("refresh_token", null, null, null, refreshToken, null);
    }

    public static CreateTokenRequest clientCredentialsGrant() {
        return new CreateTokenRequest("client_credentials", null, null, null, null, null);
    }

    public static CreateTokenRequest kerberosGrant(char[] kerberosTicket) {
        if (kerberosTicket == null || kerberosTicket.length == 0) {
            throw new IllegalArgumentException("kerberos ticket is required");
        }
        return new CreateTokenRequest("_kerberos", null, null, null, null, kerberosTicket);
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public char[] getKerberosTicket() {
        return this.kerberosTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("grant_type", this.grantType);
        if (this.scope != null) {
            builder.field("scope", this.scope);
        }
        if (this.username != null) {
            builder.field("username", this.username);
        }
        if (this.password != null) {
            byte[] passwordBytes = CharArrays.toUtf8Bytes(this.password);
            try {
                builder.field("password").utf8Value(passwordBytes, 0, passwordBytes.length);
            }
            finally {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
        if (this.refreshToken != null) {
            builder.field("refresh_token", this.refreshToken);
        }
        if (this.kerberosTicket != null) {
            byte[] kerberosTicketBytes = CharArrays.toUtf8Bytes(this.kerberosTicket);
            try {
                builder.field("kerberos_ticket").utf8Value(kerberosTicketBytes, 0, kerberosTicketBytes.length);
            }
            finally {
                Arrays.fill(kerberosTicketBytes, (byte)0);
            }
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTokenRequest that = (CreateTokenRequest)o;
        return Objects.equals(this.grantType, that.grantType) && Objects.equals(this.scope, that.scope) && Objects.equals(this.username, that.username) && Arrays.equals(this.password, that.password) && Objects.equals(this.refreshToken, that.refreshToken) && Arrays.equals(this.kerberosTicket, that.kerberosTicket);
    }

    public int hashCode() {
        int result = Objects.hash(this.grantType, this.scope, this.username, this.refreshToken);
        result = 31 * result + Arrays.hashCode(this.password);
        result = 31 * result + Arrays.hashCode(this.kerberosTicket);
        return result;
    }
}

