/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.inference.trainedmodel.langident;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class LangNetLayer
implements ToXContentObject {
    public static final ParseField NAME = new ParseField("lang_net_layer", new String[0]);
    private static final ParseField NUM_ROWS = new ParseField("num_rows", new String[0]);
    private static final ParseField NUM_COLS = new ParseField("num_cols", new String[0]);
    private static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ParseField BIAS = new ParseField("bias", new String[0]);
    public static final ConstructingObjectParser<LangNetLayer, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new LangNetLayer((List)a[0], (int)((Integer)a[1]), (int)((Integer)a[2]), (List)a[3]));
    private final double[] weights;
    private final int weightRows;
    private final int weightCols;
    private final double[] bias;

    private LangNetLayer(List<Double> weights, int numCols, int numRows, List<Double> bias) {
        this(weights.stream().mapToDouble(Double::doubleValue).toArray(), numCols, numRows, bias.stream().mapToDouble(Double::doubleValue).toArray());
    }

    LangNetLayer(double[] weights, int numCols, int numRows, double[] bias) {
        this.weights = weights;
        this.weightCols = numCols;
        this.weightRows = numRows;
        this.bias = bias;
    }

    double[] getWeights() {
        return this.weights;
    }

    int getWeightRows() {
        return this.weightRows;
    }

    int getWeightCols() {
        return this.weightCols;
    }

    double[] getBias() {
        return this.bias;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_COLS.getPreferredName(), this.weightCols);
        builder.field(NUM_ROWS.getPreferredName(), this.weightRows);
        builder.field(WEIGHTS.getPreferredName(), this.weights);
        builder.field(BIAS.getPreferredName(), this.bias);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LangNetLayer that = (LangNetLayer)o;
        return Arrays.equals(this.weights, that.weights) && Arrays.equals(this.bias, that.bias) && Objects.equals(this.weightCols, that.weightCols) && Objects.equals(this.weightRows, that.weightRows);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.weights), Arrays.hashCode(this.bias), this.weightCols, this.weightRows);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), WEIGHTS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_COLS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_ROWS);
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), BIAS);
    }
}

