/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.CompositeIndicesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.RealtimeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class MultiTermVectorsRequest
extends ActionRequest
implements Iterable<TermVectorsRequest>,
CompositeIndicesRequest,
RealtimeRequest {
    String preference;
    List<TermVectorsRequest> requests = new ArrayList<TermVectorsRequest>();
    final Set<String> ids = new HashSet<String>();

    public MultiTermVectorsRequest(StreamInput in) throws IOException {
        super(in);
        this.preference = in.readOptionalString();
        int size = in.readVInt();
        this.requests = new ArrayList<TermVectorsRequest>(size);
        for (int i = 0; i < size; ++i) {
            this.requests.add(new TermVectorsRequest(in));
        }
    }

    public MultiTermVectorsRequest() {
    }

    public MultiTermVectorsRequest add(TermVectorsRequest termVectorsRequest) {
        this.requests.add(termVectorsRequest);
        return this;
    }

    public MultiTermVectorsRequest add(String index, @Nullable String type, String id) {
        this.requests.add(new TermVectorsRequest(index, type, id));
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("multi term vectors: no documents requested", validationException);
        } else {
            for (int i = 0; i < this.requests.size(); ++i) {
                TermVectorsRequest termVectorsRequest = this.requests.get(i);
                ActionRequestValidationException validationExceptionForDoc = termVectorsRequest.validate();
                if (validationExceptionForDoc == null) continue;
                validationException = ValidateActions.addValidationError("at multi term vectors for doc " + i, validationExceptionForDoc);
            }
        }
        return validationException;
    }

    @Override
    public Iterator<TermVectorsRequest> iterator() {
        return Collections.unmodifiableCollection(this.requests).iterator();
    }

    public boolean isEmpty() {
        return this.requests.isEmpty() && this.ids.isEmpty();
    }

    public List<TermVectorsRequest> getRequests() {
        return this.requests;
    }

    public void add(TermVectorsRequest template, @Nullable XContentParser parser) throws IOException {
        String currentFieldName = null;
        if (parser != null) {
            XContentParser.Token token;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("docs".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token != XContentParser.Token.START_OBJECT) {
                                throw new IllegalArgumentException("docs array element should include an object");
                            }
                            TermVectorsRequest termVectorsRequest = new TermVectorsRequest(template);
                            if (termVectorsRequest.type() == null) {
                                termVectorsRequest.type("_doc");
                            }
                            TermVectorsRequest.parseRequest(termVectorsRequest, parser);
                            this.add(termVectorsRequest);
                        }
                        continue;
                    }
                    if ("ids".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (!token.isValue()) {
                                throw new IllegalArgumentException("ids array element should only contain ids");
                            }
                            this.ids.add(parser.text());
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("no parameter named [{}] and type ARRAY", currentFieldName);
                }
                if (token == XContentParser.Token.START_OBJECT && currentFieldName != null) {
                    if ("parameters".equals(currentFieldName)) {
                        TermVectorsRequest.parseRequest(template, parser);
                        continue;
                    }
                    throw new ElasticsearchParseException("no parameter named [{}] and type OBJECT", currentFieldName);
                }
                if (currentFieldName == null) continue;
                throw new ElasticsearchParseException("_mtermvectors: Parameter [{}] not supported", currentFieldName);
            }
        }
        for (String id : this.ids) {
            TermVectorsRequest curRequest = new TermVectorsRequest(template);
            curRequest.id(id);
            this.requests.add(curRequest);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.preference);
        out.writeVInt(this.requests.size());
        for (TermVectorsRequest termVectorsRequest : this.requests) {
            termVectorsRequest.writeTo(out);
        }
    }

    public void ids(String[] ids) {
        for (String id : ids) {
            this.ids.add(id.replaceAll("\\s", ""));
        }
    }

    public int size() {
        return this.requests.size();
    }

    public MultiTermVectorsRequest realtime(boolean realtime) {
        for (TermVectorsRequest request : this.requests) {
            request.realtime(realtime);
        }
        return this;
    }
}

