/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexNotFoundException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.DocsStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportResizeAction
extends TransportMasterNodeAction<ResizeRequest, ResizeResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        this("indices:admin/resize", transportService, clusterService, threadPool, createIndexService, actionFilters, indexNameExpressionResolver, client);
    }

    protected TransportResizeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, ResizeRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
        this.client = client;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ResizeResponse read(StreamInput in) throws IOException {
        return new ResizeResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getTargetIndexRequest().index());
    }

    @Override
    protected void masterOperation(ResizeRequest resizeRequest, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getSourceIndex());
        String targetIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getTargetIndexRequest().index());
        this.client.admin().indices().prepareStats(sourceIndex).clear().setDocs(true).execute(ActionListener.delegateFailure(listener, (delegatedListener, indicesStatsResponse) -> {
            CreateIndexClusterStateUpdateRequest updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, state, i -> {
                IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                return shard == null ? null : shard.getPrimary().getDocs();
            }, sourceIndex, targetIndex);
            this.createIndexService.createIndex(updateRequest, ActionListener.map(delegatedListener, response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
        }));
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest resizeRequest, ClusterState state, IntFunction<DocsStats> perShardDocStats, String sourceIndexName, String targetIndexName) {
        int numShards;
        CreateIndexRequest targetIndex = resizeRequest.getTargetIndexRequest();
        IndexMetadata metadata = state.metadata().index(sourceIndexName);
        if (metadata == null) {
            throw new IndexNotFoundException(sourceIndexName);
        }
        Settings.Builder targetIndexSettingsBuilder = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.");
        targetIndexSettingsBuilder.remove("index.history.uuid");
        Settings targetIndexSettings = targetIndexSettingsBuilder.build();
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            numShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings);
        } else {
            assert (resizeRequest.getResizeType() != ResizeType.SPLIT) : "split must specify the number of shards explicitly";
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                numShards = 1;
            } else {
                assert (resizeRequest.getResizeType() == ResizeType.CLONE);
                numShards = metadata.getNumberOfShards();
            }
        }
        for (int i = 0; i < numShards; ++i) {
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                Set<ShardId> shardIds = IndexMetadata.selectShrinkShards(i, metadata, numShards);
                long count = 0L;
                for (ShardId id : shardIds) {
                    DocsStats docsStats = perShardDocStats.apply(id.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + shardIds);
                }
                continue;
            }
            if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
                Objects.requireNonNull(IndexMetadata.selectSplitShard(i, metadata, numShards));
                continue;
            }
            Objects.requireNonNull(IndexMetadata.selectCloneShard(i, metadata, numShards));
        }
        if (IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("cannot provide a routing partition size value when resizing an index");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(targetIndexSettings)) {
            boolean splitFromSingleShards;
            boolean bl = splitFromSingleShards = resizeRequest.getResizeType() == ResizeType.SPLIT && metadata.getNumberOfShards() == 1;
            if (!splitFromSingleShards) {
                throw new IllegalArgumentException("cannot provide index.number_of_routing_shards on resize");
            }
        }
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(metadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(targetIndexSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(targetIndexSettings).booleanValue()) {
            throw new IllegalArgumentException("Can't disable [index.soft_deletes.enabled] setting on resize");
        }
        String cause = resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT) + "_index";
        targetIndex.cause(cause);
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", numShards);
        targetIndex.settings(settingsBuilder);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, targetIndex.index(), targetIndexName).ackTimeout(targetIndex.timeout())).masterNodeTimeout(targetIndex.masterNodeTimeout())).settings(targetIndex.settings()).aliases(targetIndex.aliases()).waitForActiveShards(targetIndex.waitForActiveShards()).recoverFrom(metadata.getIndex()).resizeType(resizeRequest.getResizeType()).copySettings(resizeRequest.getCopySettings() == null ? false : resizeRequest.getCopySettings());
    }

    @Override
    protected String getMasterActionName(DiscoveryNode node) {
        if (node.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION)) {
            return super.getMasterActionName(node);
        }
        return "indices:admin/shrink";
    }
}

