/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.RequestValidators;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.Metadata;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataIndexAliasesService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.Index;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportIndicesAliasesAction
extends TransportMasterNodeAction<IndicesAliasesRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesAliasesAction.class);
    private final MetadataIndexAliasesService indexAliasesService;
    private final RequestValidators<IndicesAliasesRequest> requestValidators;

    @Inject
    public TransportIndicesAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexAliasesService indexAliasesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<IndicesAliasesRequest> requestValidators) {
        super("indices:admin/aliases", transportService, clusterService, threadPool, actionFilters, IndicesAliasesRequest::new, indexNameExpressionResolver);
        this.indexAliasesService = indexAliasesService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet indices = new HashSet();
        for (IndicesAliasesRequest.AliasActions aliasAction : request.aliasActions()) {
            Collections.addAll(indices, aliasAction.indices());
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices.toArray(new String[indices.size()]));
    }

    @Override
    protected void masterOperation(IndicesAliasesRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        List<IndicesAliasesRequest.AliasActions> actions = request.aliasActions();
        ArrayList<AliasAction> finalActions = new ArrayList<AliasAction>();
        HashSet aliases = new HashSet();
        for (IndicesAliasesRequest.AliasActions action : actions) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), false, action.indices())) {
                IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(concreteIndex.getName());
                assert (indexAbstraction != null) : "invalid cluster metadata. index [" + concreteIndex.getName() + "] was not found";
                if (indexAbstraction.getParentDataStream() == null) continue;
                throw new IllegalArgumentException("The provided expressions [" + String.join((CharSequence)",", action.indices()) + "] match a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support aliases.");
            }
            Optional<Exception> maybeException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeException.isPresent()) {
                listener.onFailure(maybeException.get());
                return;
            }
            Collections.addAll(aliases, action.getOriginalAliases());
            block7: for (Index index : concreteIndices) {
                switch (action.actionType()) {
                    case ADD: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index.getName())) {
                            finalActions.add(new AliasAction.Add(index.getName(), alias, action.filter(), action.indexRouting(), action.searchRouting(), action.writeIndex(), action.isHidden()));
                        }
                        continue block7;
                    }
                    case REMOVE: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index.getName())) {
                            finalActions.add(new AliasAction.Remove(index.getName(), alias, action.mustExist()));
                        }
                        continue block7;
                    }
                    case REMOVE_INDEX: {
                        finalActions.add(new AliasAction.RemoveIndex(index.getName()));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + (Object)((Object)action.actionType()) + "]");
                    }
                }
            }
        }
        if (finalActions.isEmpty() && !actions.isEmpty()) {
            throw new AliasesNotFoundException(aliases.toArray(new String[aliases.size()]));
        }
        request.aliasActions().clear();
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(Collections.unmodifiableList(finalActions)).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        this.indexAliasesService.indicesAliases(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Exception t) {
                logger.debug("failed to perform aliases", (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private static String[] concreteAliases(IndicesAliasesRequest.AliasActions action, Metadata metadata, String concreteIndex) {
        if (action.expandAliasesWildcards()) {
            String[] indexAsArray = new String[]{concreteIndex};
            ImmutableOpenMap<String, List<AliasMetadata>> aliasMetadata = metadata.findAliases(action, indexAsArray);
            ArrayList<String> finalAliases = new ArrayList<String>();
            for (ObjectCursor<List<AliasMetadata>> objectCursor : aliasMetadata.values()) {
                for (AliasMetadata aliasMeta : (List)objectCursor.value) {
                    finalAliases.add(aliasMeta.alias());
                }
            }
            return finalAliases.toArray(new String[finalAliases.size()]);
        }
        return action.aliases();
    }
}

