/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class TransportPutStoredScriptAction
extends TransportMasterNodeAction<PutStoredScriptRequest, AcknowledgedResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportPutStoredScriptAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService) {
        super("cluster:admin/script/put", transportService, clusterService, threadPool, actionFilters, PutStoredScriptRequest::new, indexNameExpressionResolver);
        this.scriptService = scriptService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(PutStoredScriptRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.scriptService.putStoredScript(this.clusterService, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(PutStoredScriptRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

