/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.Vector;

public class PlanetModel
implements SerializableObject {
    public static final PlanetModel SPHERE = new PlanetModel(1.0, 1.0);
    public static final PlanetModel WGS84 = new PlanetModel(6378137.0, 6356752.314245);
    public static final PlanetModel CLARKE_1866 = new PlanetModel(6378206.4, 6356583.8);
    public final double a;
    public final double b;
    public final double xyScaling;
    public final double zScaling;
    public final double inverseXYScaling;
    public final double inverseZScaling;
    public final double inverseXYScalingSquared;
    public final double inverseZScalingSquared;
    public final double scaledFlattening;
    public final double squareRatio;
    public final double meanRadius;
    public final double scale;
    public final double inverseScale;
    public final GeoPoint NORTH_POLE;
    public final GeoPoint SOUTH_POLE;
    public final GeoPoint MIN_X_POLE;
    public final GeoPoint MAX_X_POLE;
    public final GeoPoint MIN_Y_POLE;
    public final GeoPoint MAX_Y_POLE;
    public final double minimumPoleDistance;
    private static final int BITS = 32;
    public final double MAX_VALUE;
    private final double MUL;
    public final double DECODE;
    public final int MAX_ENCODED_VALUE;
    public final int MIN_ENCODED_VALUE;
    public final DocValueEncoder docValueEncoder;

    public PlanetModel(double semiMajorAxis, double semiMinorAxis) {
        this.a = semiMajorAxis;
        this.b = semiMinorAxis;
        this.meanRadius = (2.0 * semiMajorAxis + semiMinorAxis) / 3.0;
        this.xyScaling = semiMajorAxis / this.meanRadius;
        this.zScaling = semiMinorAxis / this.meanRadius;
        this.scale = (2.0 * this.xyScaling + this.zScaling) / 3.0;
        this.inverseXYScaling = 1.0 / this.xyScaling;
        this.inverseZScaling = 1.0 / this.zScaling;
        this.scaledFlattening = (this.xyScaling - this.zScaling) * this.inverseXYScaling;
        this.squareRatio = (this.xyScaling * this.xyScaling - this.zScaling * this.zScaling) / (this.zScaling * this.zScaling);
        this.inverseXYScalingSquared = this.inverseXYScaling * this.inverseXYScaling;
        this.inverseZScalingSquared = this.inverseZScaling * this.inverseZScaling;
        this.NORTH_POLE = new GeoPoint(this.zScaling, 0.0, 0.0, 1.0, 1.5707963267948966, 0.0);
        this.SOUTH_POLE = new GeoPoint(this.zScaling, 0.0, 0.0, -1.0, -1.5707963267948966, 0.0);
        this.MIN_X_POLE = new GeoPoint(this.xyScaling, -1.0, 0.0, 0.0, 0.0, -Math.PI);
        this.MAX_X_POLE = new GeoPoint(this.xyScaling, 1.0, 0.0, 0.0, 0.0, 0.0);
        this.MIN_Y_POLE = new GeoPoint(this.xyScaling, 0.0, -1.0, 0.0, 0.0, -1.5707963267948966);
        this.MAX_Y_POLE = new GeoPoint(this.xyScaling, 0.0, 1.0, 0.0, 0.0, 1.5707963267948966);
        this.inverseScale = 1.0 / this.scale;
        this.minimumPoleDistance = Math.min(this.surfaceDistance(this.NORTH_POLE, this.SOUTH_POLE), this.surfaceDistance(this.MIN_X_POLE, this.MAX_X_POLE));
        this.MAX_VALUE = this.getMaximumMagnitude();
        this.MUL = 4.294967296E9 / (2.0 * this.MAX_VALUE);
        this.DECODE = PlanetModel.getNextSafeDouble(1.0 / this.MUL);
        this.MIN_ENCODED_VALUE = this.encodeValue(-this.MAX_VALUE);
        this.MAX_ENCODED_VALUE = this.encodeValue(this.MAX_VALUE);
        this.docValueEncoder = new DocValueEncoder(this);
    }

    public PlanetModel(InputStream inputStream) throws IOException {
        this(SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.a);
        SerializableObject.writeDouble(outputStream, this.b);
    }

    public boolean isSphere() {
        return this.xyScaling == this.zScaling;
    }

    public double getMinimumMagnitude() {
        return Math.min(this.xyScaling, this.zScaling);
    }

    public double getMaximumMagnitude() {
        return Math.max(this.xyScaling, this.zScaling);
    }

    public double getMinimumXValue() {
        return -this.xyScaling;
    }

    public double getMaximumXValue() {
        return this.xyScaling;
    }

    public double getMinimumYValue() {
        return -this.xyScaling;
    }

    public double getMaximumYValue() {
        return this.xyScaling;
    }

    public double getMinimumZValue() {
        return -this.zScaling;
    }

    public double getMaximumZValue() {
        return this.zScaling;
    }

    public double getMeanRadius() {
        return this.meanRadius;
    }

    public int encodeValue(double x) {
        if (x > this.getMaximumMagnitude()) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (greater than planetMax=" + this.getMaximumMagnitude() + ")");
        }
        if (x == this.getMaximumMagnitude()) {
            x = Math.nextDown(x);
        }
        if (x < -this.getMaximumMagnitude()) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (less than than -planetMax=" + -this.getMaximumMagnitude() + ")");
        }
        long result = (long)Math.floor(x / this.DECODE);
        assert (result >= Integer.MIN_VALUE);
        assert (result <= Integer.MAX_VALUE);
        return (int)result;
    }

    public double decodeValue(int x) {
        double result = x == this.MIN_ENCODED_VALUE ? -this.MAX_VALUE : (x == this.MAX_ENCODED_VALUE ? this.MAX_VALUE : ((double)x + 0.5) * this.DECODE);
        assert (result >= -this.MAX_VALUE && result <= this.MAX_VALUE);
        return result;
    }

    public DocValueEncoder getDocValueEncoder() {
        return this.docValueEncoder;
    }

    private static double getNextSafeDouble(double x) {
        long bits = Double.doubleToLongBits(x);
        bits += Integer.MAX_VALUE;
        double result = Double.longBitsToDouble(bits &= Integer.MIN_VALUE);
        assert (result >= x);
        return result;
    }

    public boolean pointOnSurface(Vector v) {
        return this.pointOnSurface(v.x, v.y, v.z);
    }

    public boolean pointOnSurface(double x, double y, double z) {
        return Math.abs(x * x * this.inverseXYScaling * this.inverseXYScaling + y * y * this.inverseXYScaling * this.inverseXYScaling + z * z * this.inverseZScaling * this.inverseZScaling - 1.0) < 1.0E-12;
    }

    public boolean pointOutside(Vector v) {
        return this.pointOutside(v.x, v.y, v.z);
    }

    public boolean pointOutside(double x, double y, double z) {
        return (x * x + y * y) * this.inverseXYScaling * this.inverseXYScaling + z * z * this.inverseZScaling * this.inverseZScaling - 1.0 > 1.0E-12;
    }

    public GeoPoint createSurfacePoint(Vector vector) {
        return this.createSurfacePoint(vector.x, vector.y, vector.z);
    }

    public GeoPoint createSurfacePoint(double x, double y, double z) {
        double t = Math.sqrt(1.0 / (x * x * this.inverseXYScalingSquared + y * y * this.inverseXYScalingSquared + z * z * this.inverseZScalingSquared));
        return new GeoPoint(t * x, t * y, t * z);
    }

    public GeoPoint bisection(GeoPoint pt1, GeoPoint pt2) {
        double A0 = (pt1.x + pt2.x) * 0.5;
        double B0 = (pt1.y + pt2.y) * 0.5;
        double C0 = (pt1.z + pt2.z) * 0.5;
        double denom = this.inverseXYScalingSquared * A0 * A0 + this.inverseXYScalingSquared * B0 * B0 + this.inverseZScalingSquared * C0 * C0;
        if (denom < 1.0E-12) {
            return null;
        }
        double t = Math.sqrt(1.0 / denom);
        return new GeoPoint(t * A0, t * B0, t * C0);
    }

    public double surfaceDistance(GeoPoint pt1, GeoPoint pt2) {
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C2;
        double L = pt2.getLongitude() - pt1.getLongitude();
        double U1 = Math.atan((1.0 - this.scaledFlattening) * Math.tan(pt1.getLatitude()));
        double U2 = Math.atan((1.0 - this.scaledFlattening) * Math.tan(pt2.getLatitude()));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double dCosU1CosU2 = cosU1 * cosU2;
        double dCosU1SinU2 = cosU1 * sinU2;
        double dSinU1SinU2 = sinU1 * sinU2;
        double dSinU1CosU2 = sinU1 * cosU2;
        double lambda = L;
        double lambdaP = Math.PI * 2;
        int iterLimit = 0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (dCosU1SinU2 - dSinU1CosU2 * (cosLambda = Math.cos(lambda))) * (dCosU1SinU2 - dSinU1CosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = dSinU1SinU2 + dCosU1CosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = dCosU1CosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * dSinU1SinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C2 = this.scaledFlattening / 16.0 * cosSqAlpha * (4.0 + this.scaledFlattening * (4.0 - 3.0 * cosSqAlpha)))) * this.scaledFlattening * sinAlpha * (sigma + C2 * sinSigma * (cos2SigmaM + C2 * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) >= 1.0E-12 && ++iterLimit < 100);
        double uSq = cosSqAlpha * this.squareRatio;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return this.zScaling * this.inverseScale * A * (sigma - deltaSigma);
    }

    public GeoPoint surfacePointOnBearing(GeoPoint from, double dist, double bearing) {
        double \u03c3\u02b9;
        double cos\u03c3;
        double cos2\u03c3M;
        double sin\u03c3;
        double \u0394\u03c3;
        double lat = from.getLatitude();
        double lon = from.getLongitude();
        double sin\u03b11 = Math.sin(bearing);
        double cos\u03b11 = Math.cos(bearing);
        double tanU1 = (1.0 - this.scaledFlattening) * Math.tan(lat);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double \u03c31 = Math.atan2(tanU1, cos\u03b11);
        double sin\u03b1 = cosU1 * sin\u03b11;
        double cosSq\u03b1 = 1.0 - sin\u03b1 * sin\u03b1;
        double uSq = cosSq\u03b1 * this.squareRatio;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double \u03c3 = dist / (this.zScaling * this.inverseScale * A);
        double iterations = 0.0;
        do {
            cos2\u03c3M = Math.cos(2.0 * \u03c31 + \u03c3);
        } while (Math.abs((\u03c3 = dist / (this.zScaling * this.inverseScale * A) + (\u0394\u03c3 = B * (sin\u03c3 = Math.sin(\u03c3)) * (cos2\u03c3M + B / 4.0 * ((cos\u03c3 = Math.cos(\u03c3)) * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M) - B / 6.0 * cos2\u03c3M * (-3.0 + 4.0 * sin\u03c3 * sin\u03c3) * (-3.0 + 4.0 * cos2\u03c3M * cos2\u03c3M))))) - (\u03c3\u02b9 = \u03c3)) >= 1.0E-12 && (iterations += 1.0) < 100.0);
        double x = sinU1 * sin\u03c3 - cosU1 * cos\u03c3 * cos\u03b11;
        double \u03c62 = Math.atan2(sinU1 * cos\u03c3 + cosU1 * sin\u03c3 * cos\u03b11, (1.0 - this.scaledFlattening) * Math.sqrt(sin\u03b1 * sin\u03b1 + x * x));
        double \u03bb = Math.atan2(sin\u03c3 * sin\u03b11, cosU1 * cos\u03c3 - sinU1 * sin\u03c3 * cos\u03b11);
        double C2 = this.scaledFlattening / 16.0 * cosSq\u03b1 * (4.0 + this.scaledFlattening * (4.0 - 3.0 * cosSq\u03b1));
        double L = \u03bb - (1.0 - C2) * this.scaledFlattening * sin\u03b1 * (\u03c3 + C2 * sin\u03c3 * (cos2\u03c3M + C2 * cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M)));
        double \u03bb2 = (lon + L + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new GeoPoint(this, \u03c62, \u03bb2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlanetModel)) {
            return false;
        }
        PlanetModel other = (PlanetModel)o;
        return this.a == other.a && this.b == other.b;
    }

    public int hashCode() {
        return Double.hashCode(this.a) + Double.hashCode(this.b);
    }

    public String toString() {
        if (this.equals(SPHERE)) {
            return "PlanetModel.SPHERE";
        }
        if (this.equals(WGS84)) {
            return "PlanetModel.WGS84";
        }
        if (this.equals(CLARKE_1866)) {
            return "PlanetModel.CLARKE_1866";
        }
        return "PlanetModel(xyScaling=" + this.a + " zScaling=" + this.b + ")";
    }

    public static class DocValueEncoder {
        private final PlanetModel planetModel;
        private static final double inverseMaximumValue = 4.768373855769089E-7;
        private final double inverseXFactor;
        private final double inverseYFactor;
        private final double inverseZFactor;
        private final double xFactor;
        private final double yFactor;
        private final double zFactor;
        private static final double STEP_FUDGE = 10.0;
        private final double xStep;
        private final double yStep;
        private final double zStep;

        private DocValueEncoder(PlanetModel planetModel) {
            this.planetModel = planetModel;
            this.inverseXFactor = (planetModel.getMaximumXValue() - planetModel.getMinimumXValue()) * 4.768373855769089E-7;
            this.inverseYFactor = (planetModel.getMaximumYValue() - planetModel.getMinimumYValue()) * 4.768373855769089E-7;
            this.inverseZFactor = (planetModel.getMaximumZValue() - planetModel.getMinimumZValue()) * 4.768373855769089E-7;
            this.xFactor = 1.0 / this.inverseXFactor;
            this.yFactor = 1.0 / this.inverseYFactor;
            this.zFactor = 1.0 / this.inverseZFactor;
            this.xStep = this.inverseXFactor * 10.0;
            this.yStep = this.inverseYFactor * 10.0;
            this.zStep = this.inverseZFactor * 10.0;
        }

        public long encodePoint(GeoPoint point) {
            return this.encodePoint(point.x, point.y, point.z);
        }

        public long encodePoint(double x, double y, double z) {
            int XEncoded = this.encodeX(x);
            int YEncoded = this.encodeY(y);
            int ZEncoded = this.encodeZ(z);
            return (long)(XEncoded & 0x1FFFFF) << 42 | (long)(YEncoded & 0x1FFFFF) << 21 | (long)(ZEncoded & 0x1FFFFF);
        }

        public GeoPoint decodePoint(long docValue) {
            return new GeoPoint(this.decodeX((int)(docValue >> 42) & 0x1FFFFF), this.decodeY((int)(docValue >> 21) & 0x1FFFFF), this.decodeZ((int)docValue & 0x1FFFFF));
        }

        public double decodeXValue(long docValue) {
            return this.decodeX((int)(docValue >> 42) & 0x1FFFFF);
        }

        public double decodeYValue(long docValue) {
            return this.decodeY((int)(docValue >> 21) & 0x1FFFFF);
        }

        public double decodeZValue(long docValue) {
            return this.decodeZ((int)docValue & 0x1FFFFF);
        }

        public double roundDownX(double startValue) {
            return startValue - this.xStep;
        }

        public double roundUpX(double startValue) {
            return startValue + this.xStep;
        }

        public double roundDownY(double startValue) {
            return startValue - this.yStep;
        }

        public double roundUpY(double startValue) {
            return startValue + this.yStep;
        }

        public double roundDownZ(double startValue) {
            return startValue - this.zStep;
        }

        public double roundUpZ(double startValue) {
            return startValue + this.zStep;
        }

        private int encodeX(double x) {
            if (x > this.planetModel.getMaximumXValue()) {
                throw new IllegalArgumentException("x value exceeds planet model maximum");
            }
            if (x < this.planetModel.getMinimumXValue()) {
                throw new IllegalArgumentException("x value less than planet model minimum");
            }
            return (int)Math.floor((x - this.planetModel.getMinimumXValue()) * this.xFactor + 0.5);
        }

        private double decodeX(int x) {
            return (double)x * this.inverseXFactor + this.planetModel.getMinimumXValue();
        }

        private int encodeY(double y) {
            if (y > this.planetModel.getMaximumYValue()) {
                throw new IllegalArgumentException("y value exceeds planet model maximum");
            }
            if (y < this.planetModel.getMinimumYValue()) {
                throw new IllegalArgumentException("y value less than planet model minimum");
            }
            return (int)Math.floor((y - this.planetModel.getMinimumYValue()) * this.yFactor + 0.5);
        }

        private double decodeY(int y) {
            return (double)y * this.inverseYFactor + this.planetModel.getMinimumYValue();
        }

        private int encodeZ(double z) {
            if (z > this.planetModel.getMaximumZValue()) {
                throw new IllegalArgumentException("z value exceeds planet model maximum");
            }
            if (z < this.planetModel.getMinimumZValue()) {
                throw new IllegalArgumentException("z value less than planet model minimum");
            }
            return (int)Math.floor((z - this.planetModel.getMinimumZValue()) * this.zFactor + 0.5);
        }

        private double decodeZ(int z) {
            return (double)z * this.inverseZFactor + this.planetModel.getMinimumZValue();
        }
    }
}

