/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupSelector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;

abstract class CollapsingDocValuesSource<T>
extends GroupSelector<T> {
    protected final String field;

    CollapsingDocValuesSource(String field) {
        this.field = field;
    }

    @Override
    public void setGroups(Collection<SearchGroup<T>> groups) {
        throw new UnsupportedOperationException();
    }

    private static DocValuesType getDocValuesType(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            return fi.getDocValuesType();
        }
        return null;
    }

    static class Keyword
    extends CollapsingDocValuesSource<BytesRef> {
        private SortedDocValues values;
        private int ord;

        Keyword(MappedFieldType fieldType) {
            super(fieldType.name());
        }

        @Override
        public GroupSelector.State advanceTo(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.ord = this.values.ordValue();
                return GroupSelector.State.ACCEPT;
            }
            this.ord = -1;
            return GroupSelector.State.SKIP;
        }

        @Override
        public BytesRef currentValue() {
            if (this.ord == -1) {
                return null;
            }
            try {
                return this.values.lookupOrd(this.ord);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public BytesRef copyValue() {
            BytesRef value = this.currentValue();
            if (value == null) {
                return null;
            }
            return BytesRef.deepCopyOf(value);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            LeafReader reader = readerContext.reader();
            DocValuesType type = CollapsingDocValuesSource.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptySorted();
                return;
            }
            switch (type) {
                case SORTED: {
                    this.values = DocValues.getSorted(reader, this.field);
                    break;
                }
                case SORTED_SET: {
                    final SortedSetDocValues sorted = DocValues.getSortedSet(reader, this.field);
                    this.values = DocValues.unwrapSingleton(sorted);
                    if (this.values != null) break;
                    this.values = new AbstractSortedDocValues(){
                        private int ord;

                        @Override
                        public boolean advanceExact(int target) throws IOException {
                            if (sorted.advanceExact(target)) {
                                this.ord = (int)sorted.nextOrd();
                                if (sorted.nextOrd() != -1L) {
                                    throw new IllegalStateException("failed to collapse " + target + ", the collapse field must be single valued");
                                }
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public int docID() {
                            return sorted.docID();
                        }

                        @Override
                        public int ordValue() {
                            return this.ord;
                        }

                        @Override
                        public BytesRef lookupOrd(int ord) throws IOException {
                            return sorted.lookupOrd(ord);
                        }

                        @Override
                        public int getValueCount() {
                            return (int)sorted.getValueCount();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected doc values type " + (Object)((Object)type) + "` for field `" + this.field + "`");
                }
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    static class Numeric
    extends CollapsingDocValuesSource<Long> {
        private NumericDocValues values;
        private long value;
        private boolean hasValue;

        Numeric(MappedFieldType fieldType) {
            super(fieldType.name());
        }

        @Override
        public GroupSelector.State advanceTo(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.hasValue = true;
                this.value = this.values.longValue();
                return GroupSelector.State.ACCEPT;
            }
            this.hasValue = false;
            return GroupSelector.State.SKIP;
        }

        @Override
        public Long currentValue() {
            return this.hasValue ? Long.valueOf(this.value) : null;
        }

        @Override
        public Long copyValue() {
            return this.currentValue();
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            LeafReader reader = readerContext.reader();
            DocValuesType type = CollapsingDocValuesSource.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptyNumeric();
                return;
            }
            switch (type) {
                case NUMERIC: {
                    this.values = DocValues.getNumeric(reader, this.field);
                    break;
                }
                case SORTED_NUMERIC: {
                    final SortedNumericDocValues sorted = DocValues.getSortedNumeric(reader, this.field);
                    this.values = DocValues.unwrapSingleton(sorted);
                    if (this.values != null) break;
                    this.values = new AbstractNumericDocValues(){
                        private long value;

                        @Override
                        public boolean advanceExact(int target) throws IOException {
                            if (sorted.advanceExact(target)) {
                                if (sorted.docValueCount() > 1) {
                                    throw new IllegalStateException("failed to collapse " + target + ", the collapse field must be single valued");
                                }
                                this.value = sorted.nextValue();
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public int docID() {
                            return sorted.docID();
                        }

                        @Override
                        public long longValue() throws IOException {
                            return this.value;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected doc values type " + (Object)((Object)type) + "` for field `" + this.field + "`");
                }
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
        }
    }
}

