/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.docvalues;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.ValueSourceScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.mutable.MutableValue;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.mutable.MutableValueInt;

public abstract class IntDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public IntDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc) throws IOException {
        return (byte)this.intVal(doc);
    }

    @Override
    public short shortVal(int doc) throws IOException {
        return (short)this.intVal(doc);
    }

    @Override
    public float floatVal(int doc) throws IOException {
        return this.intVal(doc);
    }

    @Override
    public abstract int intVal(int var1) throws IOException;

    @Override
    public long longVal(int doc) throws IOException {
        return this.intVal(doc);
    }

    @Override
    public double doubleVal(int doc) throws IOException {
        return this.intVal(doc);
    }

    @Override
    public String strVal(int doc) throws IOException {
        return Integer.toString(this.intVal(doc));
    }

    @Override
    public Object objectVal(int doc) throws IOException {
        return this.exists(doc) ? Integer.valueOf(this.intVal(doc)) : null;
    }

    @Override
    public String toString(int doc) throws IOException {
        return this.vs.description() + '=' + this.strVal(doc);
    }

    @Override
    public ValueSourceScorer getRangeScorer(Weight weight, LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        int upper;
        int lower;
        if (lowerVal == null) {
            lower = Integer.MIN_VALUE;
        } else {
            lower = Integer.parseInt(lowerVal);
            if (!includeLower && lower < Integer.MAX_VALUE) {
                ++lower;
            }
        }
        if (upperVal == null) {
            upper = Integer.MAX_VALUE;
        } else {
            upper = Integer.parseInt(upperVal);
            if (!includeUpper && upper > Integer.MIN_VALUE) {
                --upper;
            }
        }
        final int ll = lower;
        final int uu = upper;
        return new ValueSourceScorer(weight, readerContext, this){

            @Override
            public boolean matches(int doc) throws IOException {
                if (!IntDocValues.this.exists(doc)) {
                    return false;
                }
                int val = IntDocValues.this.intVal(doc);
                return val >= ll && val <= uu;
            }
        };
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueInt mval = new MutableValueInt();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) throws IOException {
                this.mval.value = IntDocValues.this.intVal(doc);
                this.mval.exists = IntDocValues.this.exists(doc);
            }
        };
    }
}

