/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.IOException;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexSorter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.NamedSPILoader;

public abstract class SortFieldProvider
implements NamedSPILoader.NamedSPI {
    protected final String name;

    public static SortFieldProvider forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public static Set<String> availableSortFieldProviders() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadSortFieldProviders(ClassLoader classLoader) {
        Holder.getLoader().reload(classLoader);
    }

    public static void write(SortField sf, DataOutput output) throws IOException {
        IndexSorter sorter = sf.getIndexSorter();
        if (sorter == null) {
            throw new IllegalArgumentException("Cannot serialize sort field " + sf);
        }
        SortFieldProvider provider = SortFieldProvider.forName(sorter.getProviderName());
        provider.writeSortField(sf, output);
    }

    protected SortFieldProvider(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract SortField readSortField(DataInput var1) throws IOException;

    public abstract void writeSortField(SortField var1, DataOutput var2) throws IOException;

    private static class Holder {
        private static final NamedSPILoader<SortFieldProvider> LOADER = new NamedSPILoader<SortFieldProvider>(SortFieldProvider.class);

        private Holder() {
        }

        static NamedSPILoader<SortFieldProvider> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a SortFieldProvider by name before all SortFieldProviders could be initialized. This likely happens if you call SortFieldProvider#forName from a SortFieldProviders's ctor.");
            }
            return LOADER;
        }
    }
}

