/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc;

public final class BitMixer {
    private static final int PHI_C32 = -1640531527;
    private static final long PHI_C64 = -7046029254386353131L;

    public static int mix(byte key) {
        return key * -1640531527;
    }

    public static int mix(byte key, int seed) {
        return (key ^ seed) * -1640531527;
    }

    public static int mix(short key) {
        return BitMixer.mixPhi(key);
    }

    public static int mix(short key, int seed) {
        return BitMixer.mixPhi(key ^ seed);
    }

    public static int mix(char key) {
        return BitMixer.mixPhi(key);
    }

    public static int mix(char key, int seed) {
        return BitMixer.mixPhi(key ^ seed);
    }

    public static int mix(int key) {
        return BitMixer.mix32(key);
    }

    public static int mix(int key, int seed) {
        return BitMixer.mix32(key ^ seed);
    }

    public static int mix(float key) {
        return BitMixer.mix32(Float.floatToIntBits(key));
    }

    public static int mix(float key, int seed) {
        return BitMixer.mix32(Float.floatToIntBits(key) ^ seed);
    }

    public static int mix(double key) {
        return (int)BitMixer.mix64(Double.doubleToLongBits(key));
    }

    public static int mix(double key, int seed) {
        return (int)BitMixer.mix64(Double.doubleToLongBits(key) ^ (long)seed);
    }

    public static int mix(long key) {
        return (int)BitMixer.mix64(key);
    }

    public static int mix(long key, int seed) {
        return (int)BitMixer.mix64(key ^ (long)seed);
    }

    public static int mix(Object key) {
        return key == null ? 0 : BitMixer.mix32(key.hashCode());
    }

    public static int mix(Object key, int seed) {
        return key == null ? 0 : BitMixer.mix32(key.hashCode() ^ seed);
    }

    public static int mix32(int k) {
        k = (k ^ k >>> 16) * -2048144789;
        k = (k ^ k >>> 13) * -1028477387;
        return k ^ k >>> 16;
    }

    public static long mix64(long z) {
        z = (z ^ z >>> 32) * 5536775847593249645L;
        z = (z ^ z >>> 29) * -282946459933713943L;
        return z ^ z >>> 32;
    }

    public static int mixPhi(byte k) {
        int h = k * -1640531527;
        return h ^ h >>> 16;
    }

    public static int mixPhi(char k) {
        int h = k * -1640531527;
        return h ^ h >>> 16;
    }

    public static int mixPhi(short k) {
        int h = k * -1640531527;
        return h ^ h >>> 16;
    }

    public static int mixPhi(int k) {
        int h = k * -1640531527;
        return h ^ h >>> 16;
    }

    public static int mixPhi(float k) {
        int h = Float.floatToIntBits(k) * -1640531527;
        return h ^ h >>> 16;
    }

    public static int mixPhi(double k) {
        long h = Double.doubleToLongBits(k) * -7046029254386353131L;
        return (int)(h ^ h >>> 32);
    }

    public static int mixPhi(long k) {
        long h = k * -7046029254386353131L;
        return (int)(h ^ h >>> 32);
    }

    public static int mixPhi(Object k) {
        int h = k == null ? 0 : k.hashCode() * -1640531527;
        return h ^ h >>> 16;
    }
}

