/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.codecs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.aws.cloudwatch.CloudWatchLogEntry;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudWatchLogDataCodec
extends AbstractCodec {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchLogDataCodec.class);
    private final ObjectMapper objectMapper;

    CloudWatchLogDataCodec(Configuration configuration, ObjectMapper objectMapper) {
        super(configuration);
        this.objectMapper = objectMapper;
    }

    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        try {
            CloudWatchLogEntry entry = (CloudWatchLogEntry)this.objectMapper.readValue(rawMessage.getPayload(), CloudWatchLogEntry.class);
            try {
                return this.decodeLogData(entry, entry.logGroup, entry.logStream);
            }
            catch (Exception e) {
                LOG.error("Couldn't decode log event <{}>", (Object)entry);
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't deserialize log data", e);
        }
    }

    @Nullable
    protected abstract Message decodeLogData(@Nonnull CloudWatchLogEntry var1, @Nonnull String var2, @Nonnull String var3);

    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }
}

