/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PurgeQueueRequestMarshaller
implements Marshaller<Request<PurgeQueueRequest>, PurgeQueueRequest> {
    @Override
    public Request<PurgeQueueRequest> marshall(PurgeQueueRequest purgeQueueRequest) {
        if (purgeQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurgeQueueRequest> request = new DefaultRequest<PurgeQueueRequest>(purgeQueueRequest, "AmazonSQS");
        request.addParameter("Action", "PurgeQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (purgeQueueRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(purgeQueueRequest.getQueueUrl()));
        }
        return request;
    }
}

