/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalytics.model.ReferenceDataSource;

@SdkInternalApi
public class ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ReferenceDataSource").build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceSchema").build();
    private static final ReferenceDataSourceMarshaller instance = new ReferenceDataSourceMarshaller();

    public static ReferenceDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReferenceDataSource referenceDataSource, ProtocolMarshaller protocolMarshaller) {
        if (referenceDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(referenceDataSource.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(referenceDataSource.getS3ReferenceDataSource(), S3REFERENCEDATASOURCE_BINDING);
            protocolMarshaller.marshall(referenceDataSource.getReferenceSchema(), REFERENCESCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

