/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardSyncTaskManager {
    private static final Log LOG = LogFactory.getLog(ShardSyncTaskManager.class);
    private ITask currentTask;
    private Future<TaskResult> future;
    private final IKinesisProxy kinesisProxy;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final IMetricsFactory metricsFactory;
    private final ExecutorService executorService;
    private final InitialPositionInStreamExtended initialPositionInStream;
    private boolean cleanupLeasesUponShardCompletion;
    private boolean ignoreUnexpectedChildShards;
    private final long shardSyncIdleTimeMillis;
    private final ShardSyncer shardSyncer;

    ShardSyncTaskManager(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIdleTimeMillis, IMetricsFactory metricsFactory, ExecutorService executorService, ShardSyncer shardSyncer) {
        this.kinesisProxy = kinesisProxy;
        this.leaseManager = leaseManager;
        this.metricsFactory = metricsFactory;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIdleTimeMillis = shardSyncIdleTimeMillis;
        this.executorService = executorService;
        this.initialPositionInStream = initialPositionInStream;
        this.shardSyncer = shardSyncer;
    }

    synchronized boolean syncShardAndLeaseInfo(Set<String> closedShardIds) {
        return this.checkAndSubmitNextTask(closedShardIds);
    }

    private synchronized boolean checkAndSubmitNextTask(Set<String> closedShardIds) {
        boolean submittedNewTask = false;
        if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
            if (this.future != null && this.future.isDone()) {
                try {
                    TaskResult result = this.future.get();
                    if (result.getException() != null) {
                        LOG.error("Caught exception running " + (Object)((Object)this.currentTask.getTaskType()) + " task: ", result.getException());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)((Object)this.currentTask.getTaskType()) + " task encountered exception.", e);
                }
            }
            this.currentTask = new MetricsCollectingTaskDecorator(new ShardSyncTask(this.kinesisProxy, this.leaseManager, this.initialPositionInStream, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIdleTimeMillis, this.shardSyncer), this.metricsFactory);
            this.future = this.executorService.submit(this.currentTask);
            submittedNewTask = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitted new " + (Object)((Object)this.currentTask.getTaskType()) + " task.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Previous " + (Object)((Object)this.currentTask.getTaskType()) + " task still pending.  Not submitting new task.");
        }
        return submittedNewTask;
    }
}

