/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.NetworkInterface;
import com.amazonaws.services.ec2.model.NetworkInterfaceIpv6Address;
import com.amazonaws.services.ec2.model.NetworkInterfacePrivateIpAddress;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.GroupIdentifierStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.NetworkInterfaceAssociationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.NetworkInterfaceAttachmentStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.NetworkInterfaceIpv6AddressStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.NetworkInterfacePrivateIpAddressStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class NetworkInterfaceStaxUnmarshaller
implements Unmarshaller<NetworkInterface, StaxUnmarshallerContext> {
    private static NetworkInterfaceStaxUnmarshaller instance;

    @Override
    public NetworkInterface unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkInterface networkInterface = new NetworkInterface();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return networkInterface;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("association", targetDepth)) {
                    networkInterface.setAssociation(NetworkInterfaceAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("attachment", targetDepth)) {
                    networkInterface.setAttachment(NetworkInterfaceAttachmentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    networkInterface.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    networkInterface.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupSet", targetDepth)) {
                    networkInterface.withGroups(new ArrayList<GroupIdentifier>());
                    continue;
                }
                if (context.testExpression("groupSet/item", targetDepth)) {
                    networkInterface.withGroups(GroupIdentifierStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("interfaceType", targetDepth)) {
                    networkInterface.setInterfaceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6AddressesSet", targetDepth)) {
                    networkInterface.withIpv6Addresses(new ArrayList<NetworkInterfaceIpv6Address>());
                    continue;
                }
                if (context.testExpression("ipv6AddressesSet/item", targetDepth)) {
                    networkInterface.withIpv6Addresses(NetworkInterfaceIpv6AddressStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("macAddress", targetDepth)) {
                    networkInterface.setMacAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    networkInterface.setNetworkInterfaceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("outpostArn", targetDepth)) {
                    networkInterface.setOutpostArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    networkInterface.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateDnsName", targetDepth)) {
                    networkInterface.setPrivateDnsName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateIpAddress", targetDepth)) {
                    networkInterface.setPrivateIpAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateIpAddressesSet", targetDepth)) {
                    networkInterface.withPrivateIpAddresses(new ArrayList<NetworkInterfacePrivateIpAddress>());
                    continue;
                }
                if (context.testExpression("privateIpAddressesSet/item", targetDepth)) {
                    networkInterface.withPrivateIpAddresses(NetworkInterfacePrivateIpAddressStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requesterId", targetDepth)) {
                    networkInterface.setRequesterId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requesterManaged", targetDepth)) {
                    networkInterface.setRequesterManaged(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sourceDestCheck", targetDepth)) {
                    networkInterface.setSourceDestCheck(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    networkInterface.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("subnetId", targetDepth)) {
                    networkInterface.setSubnetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    networkInterface.withTagSet(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    networkInterface.withTagSet(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                networkInterface.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return networkInterface;
    }

    public static NetworkInterfaceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkInterfaceStaxUnmarshaller();
        }
        return instance;
    }
}

