/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AddPrefixListEntry;
import com.amazonaws.services.ec2.model.ModifyManagedPrefixListRequest;
import com.amazonaws.services.ec2.model.RemovePrefixListEntry;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyManagedPrefixListRequestMarshaller
implements Marshaller<Request<ModifyManagedPrefixListRequest>, ModifyManagedPrefixListRequest> {
    @Override
    public Request<ModifyManagedPrefixListRequest> marshall(ModifyManagedPrefixListRequest modifyManagedPrefixListRequest) {
        SdkInternalList modifyManagedPrefixListRequestRemoveEntriesList;
        SdkInternalList modifyManagedPrefixListRequestAddEntriesList;
        if (modifyManagedPrefixListRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyManagedPrefixListRequest> request = new DefaultRequest<ModifyManagedPrefixListRequest>(modifyManagedPrefixListRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyManagedPrefixList");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyManagedPrefixListRequest.getPrefixListId() != null) {
            request.addParameter("PrefixListId", StringUtils.fromString(modifyManagedPrefixListRequest.getPrefixListId()));
        }
        if (modifyManagedPrefixListRequest.getCurrentVersion() != null) {
            request.addParameter("CurrentVersion", StringUtils.fromLong(modifyManagedPrefixListRequest.getCurrentVersion()));
        }
        if (modifyManagedPrefixListRequest.getPrefixListName() != null) {
            request.addParameter("PrefixListName", StringUtils.fromString(modifyManagedPrefixListRequest.getPrefixListName()));
        }
        if (!(modifyManagedPrefixListRequestAddEntriesList = (SdkInternalList)modifyManagedPrefixListRequest.getAddEntries()).isEmpty() || !modifyManagedPrefixListRequestAddEntriesList.isAutoConstruct()) {
            int addEntriesListIndex = 1;
            for (AddPrefixListEntry modifyManagedPrefixListRequestAddEntriesListValue : modifyManagedPrefixListRequestAddEntriesList) {
                if (modifyManagedPrefixListRequestAddEntriesListValue.getCidr() != null) {
                    request.addParameter("AddEntry." + addEntriesListIndex + ".Cidr", StringUtils.fromString(modifyManagedPrefixListRequestAddEntriesListValue.getCidr()));
                }
                if (modifyManagedPrefixListRequestAddEntriesListValue.getDescription() != null) {
                    request.addParameter("AddEntry." + addEntriesListIndex + ".Description", StringUtils.fromString(modifyManagedPrefixListRequestAddEntriesListValue.getDescription()));
                }
                ++addEntriesListIndex;
            }
        }
        if (!(modifyManagedPrefixListRequestRemoveEntriesList = (SdkInternalList)modifyManagedPrefixListRequest.getRemoveEntries()).isEmpty() || !modifyManagedPrefixListRequestRemoveEntriesList.isAutoConstruct()) {
            int removeEntriesListIndex = 1;
            for (RemovePrefixListEntry modifyManagedPrefixListRequestRemoveEntriesListValue : modifyManagedPrefixListRequestRemoveEntriesList) {
                if (modifyManagedPrefixListRequestRemoveEntriesListValue.getCidr() != null) {
                    request.addParameter("RemoveEntry." + removeEntriesListIndex + ".Cidr", StringUtils.fromString(modifyManagedPrefixListRequestRemoveEntriesListValue.getCidr()));
                }
                ++removeEntriesListIndex;
            }
        }
        return request;
    }
}

