/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.services.ec2.model.transform.ModifyFleetRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyFleetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyFleetRequest> {
    private String excessCapacityTerminationPolicy;
    private SdkInternalList<FleetLaunchTemplateConfigRequest> launchTemplateConfigs;
    private String fleetId;
    private TargetCapacitySpecificationRequest targetCapacitySpecification;

    public void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
    }

    public String getExcessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public ModifyFleetRequest withExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.setExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
        return this;
    }

    public ModifyFleetRequest withExcessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
        return this;
    }

    public List<FleetLaunchTemplateConfigRequest> getLaunchTemplateConfigs() {
        if (this.launchTemplateConfigs == null) {
            this.launchTemplateConfigs = new SdkInternalList();
        }
        return this.launchTemplateConfigs;
    }

    public void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
        if (launchTemplateConfigs == null) {
            this.launchTemplateConfigs = null;
            return;
        }
        this.launchTemplateConfigs = new SdkInternalList<FleetLaunchTemplateConfigRequest>(launchTemplateConfigs);
    }

    public ModifyFleetRequest withLaunchTemplateConfigs(FleetLaunchTemplateConfigRequest ... launchTemplateConfigs) {
        if (this.launchTemplateConfigs == null) {
            this.setLaunchTemplateConfigs(new SdkInternalList<FleetLaunchTemplateConfigRequest>(launchTemplateConfigs.length));
        }
        for (FleetLaunchTemplateConfigRequest ele : launchTemplateConfigs) {
            this.launchTemplateConfigs.add(ele);
        }
        return this;
    }

    public ModifyFleetRequest withLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
        this.setLaunchTemplateConfigs(launchTemplateConfigs);
        return this;
    }

    public void setFleetId(String fleetId) {
        this.fleetId = fleetId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public ModifyFleetRequest withFleetId(String fleetId) {
        this.setFleetId(fleetId);
        return this;
    }

    public void setTargetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
        this.targetCapacitySpecification = targetCapacitySpecification;
    }

    public TargetCapacitySpecificationRequest getTargetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public ModifyFleetRequest withTargetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
        this.setTargetCapacitySpecification(targetCapacitySpecification);
        return this;
    }

    @Override
    public Request<ModifyFleetRequest> getDryRunRequest() {
        Request<ModifyFleetRequest> request = new ModifyFleetRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExcessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.getExcessCapacityTerminationPolicy()).append(",");
        }
        if (this.getLaunchTemplateConfigs() != null) {
            sb.append("LaunchTemplateConfigs: ").append(this.getLaunchTemplateConfigs()).append(",");
        }
        if (this.getFleetId() != null) {
            sb.append("FleetId: ").append(this.getFleetId()).append(",");
        }
        if (this.getTargetCapacitySpecification() != null) {
            sb.append("TargetCapacitySpecification: ").append(this.getTargetCapacitySpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFleetRequest)) {
            return false;
        }
        ModifyFleetRequest other = (ModifyFleetRequest)obj;
        if (other.getExcessCapacityTerminationPolicy() == null ^ this.getExcessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() != null && !other.getExcessCapacityTerminationPolicy().equals(this.getExcessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() == null ^ this.getLaunchTemplateConfigs() == null) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() != null && !other.getLaunchTemplateConfigs().equals(this.getLaunchTemplateConfigs())) {
            return false;
        }
        if (other.getFleetId() == null ^ this.getFleetId() == null) {
            return false;
        }
        if (other.getFleetId() != null && !other.getFleetId().equals(this.getFleetId())) {
            return false;
        }
        if (other.getTargetCapacitySpecification() == null ^ this.getTargetCapacitySpecification() == null) {
            return false;
        }
        return other.getTargetCapacitySpecification() == null || other.getTargetCapacitySpecification().equals(this.getTargetCapacitySpecification());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExcessCapacityTerminationPolicy() == null ? 0 : this.getExcessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplateConfigs() == null ? 0 : this.getLaunchTemplateConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getFleetId() == null ? 0 : this.getFleetId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacitySpecification() == null ? 0 : this.getTargetCapacitySpecification().hashCode());
        return hashCode;
    }

    @Override
    public ModifyFleetRequest clone() {
        return (ModifyFleetRequest)super.clone();
    }
}

