/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateTrafficMirrorTargetRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTrafficMirrorTargetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateTrafficMirrorTargetRequest> {
    private String networkInterfaceId;
    private String networkLoadBalancerArn;
    private String description;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String clientToken;

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public CreateTrafficMirrorTargetRequest withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public void setNetworkLoadBalancerArn(String networkLoadBalancerArn) {
        this.networkLoadBalancerArn = networkLoadBalancerArn;
    }

    public String getNetworkLoadBalancerArn() {
        return this.networkLoadBalancerArn;
    }

    public CreateTrafficMirrorTargetRequest withNetworkLoadBalancerArn(String networkLoadBalancerArn) {
        this.setNetworkLoadBalancerArn(networkLoadBalancerArn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTrafficMirrorTargetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateTrafficMirrorTargetRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateTrafficMirrorTargetRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateTrafficMirrorTargetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    @Override
    public Request<CreateTrafficMirrorTargetRequest> getDryRunRequest() {
        Request<CreateTrafficMirrorTargetRequest> request = new CreateTrafficMirrorTargetRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.getNetworkInterfaceId()).append(",");
        }
        if (this.getNetworkLoadBalancerArn() != null) {
            sb.append("NetworkLoadBalancerArn: ").append(this.getNetworkLoadBalancerArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorTargetRequest)) {
            return false;
        }
        CreateTrafficMirrorTargetRequest other = (CreateTrafficMirrorTargetRequest)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getNetworkLoadBalancerArn() == null ^ this.getNetworkLoadBalancerArn() == null) {
            return false;
        }
        if (other.getNetworkLoadBalancerArn() != null && !other.getNetworkLoadBalancerArn().equals(this.getNetworkLoadBalancerArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkLoadBalancerArn() == null ? 0 : this.getNetworkLoadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateTrafficMirrorTargetRequest clone() {
        return (CreateTrafficMirrorTargetRequest)super.clone();
    }
}

