/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Protocol;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateNetworkInsightsPathRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateNetworkInsightsPathRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateNetworkInsightsPathRequest> {
    private String sourceIp;
    private String destinationIp;
    private String source;
    private String destination;
    private String protocol;
    private Integer destinationPort;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String clientToken;

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public CreateNetworkInsightsPathRequest withSourceIp(String sourceIp) {
        this.setSourceIp(sourceIp);
        return this;
    }

    public void setDestinationIp(String destinationIp) {
        this.destinationIp = destinationIp;
    }

    public String getDestinationIp() {
        return this.destinationIp;
    }

    public CreateNetworkInsightsPathRequest withDestinationIp(String destinationIp) {
        this.setDestinationIp(destinationIp);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public CreateNetworkInsightsPathRequest withSource(String source) {
        this.setSource(source);
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public CreateNetworkInsightsPathRequest withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public CreateNetworkInsightsPathRequest withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public CreateNetworkInsightsPathRequest withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
    }

    public Integer getDestinationPort() {
        return this.destinationPort;
    }

    public CreateNetworkInsightsPathRequest withDestinationPort(Integer destinationPort) {
        this.setDestinationPort(destinationPort);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateNetworkInsightsPathRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateNetworkInsightsPathRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateNetworkInsightsPathRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    @Override
    public Request<CreateNetworkInsightsPathRequest> getDryRunRequest() {
        Request<CreateNetworkInsightsPathRequest> request = new CreateNetworkInsightsPathRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceIp() != null) {
            sb.append("SourceIp: ").append(this.getSourceIp()).append(",");
        }
        if (this.getDestinationIp() != null) {
            sb.append("DestinationIp: ").append(this.getDestinationIp()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getDestinationPort() != null) {
            sb.append("DestinationPort: ").append(this.getDestinationPort()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInsightsPathRequest)) {
            return false;
        }
        CreateNetworkInsightsPathRequest other = (CreateNetworkInsightsPathRequest)obj;
        if (other.getSourceIp() == null ^ this.getSourceIp() == null) {
            return false;
        }
        if (other.getSourceIp() != null && !other.getSourceIp().equals(this.getSourceIp())) {
            return false;
        }
        if (other.getDestinationIp() == null ^ this.getDestinationIp() == null) {
            return false;
        }
        if (other.getDestinationIp() != null && !other.getDestinationIp().equals(this.getDestinationIp())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getDestinationPort() == null ^ this.getDestinationPort() == null) {
            return false;
        }
        if (other.getDestinationPort() != null && !other.getDestinationPort().equals(this.getDestinationPort())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceIp() == null ? 0 : this.getSourceIp().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationIp() == null ? 0 : this.getDestinationIp().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPort() == null ? 0 : this.getDestinationPort().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateNetworkInsightsPathRequest clone() {
        return (CreateNetworkInsightsPathRequest)super.clone();
    }
}

