/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.configurations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.bson.types.ObjectId;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfiguration;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfigurationSnippet;
import org.graylog.plugins.collector.configurations.rest.models.CollectorInput;
import org.graylog.plugins.collector.configurations.rest.models.CollectorOutput;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CollectorConfigurationService {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorConfigurationService.class);
    private static final String COLLECTION_NAME = "collector_configurations";
    private final ClassLoader classLoader = this.getClass().getClassLoader();
    private final JacksonDBCollection<CollectorConfiguration, ObjectId> dbCollection;

    @Inject
    public CollectorConfigurationService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), CollectorConfiguration.class, ObjectId.class, (ObjectMapper)mapper.get());
    }

    public List<CollectorConfiguration> loadAll() {
        DBCursor cursor = this.dbCollection.find();
        ArrayList<CollectorConfiguration> collectorConfigurationList = new ArrayList<CollectorConfiguration>();
        Iterables.addAll(collectorConfigurationList, (Iterable)cursor);
        return collectorConfigurationList;
    }

    public CollectorConfiguration findById(String id) {
        return (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
    }

    public List<CollectorConfiguration> findByTags(List tags) {
        DBCursor cursor = (DBCursor)this.dbCollection.find().in("tags", (Collection)tags);
        ArrayList<CollectorConfiguration> result = new ArrayList<CollectorConfiguration>();
        while (cursor.hasNext()) {
            result.add((CollectorConfiguration)cursor.next());
        }
        return result;
    }

    public CollectorConfiguration save(CollectorConfiguration configuration) {
        return (CollectorConfiguration)this.dbCollection.findAndModify(DBQuery.is((String)"_id", (Object)configuration.id()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)configuration, true, true);
    }

    public int delete(String id) {
        return this.dbCollection.remove(DBQuery.is((String)"_id", (Object)id)).getN();
    }

    public CollectorConfiguration merge(List<CollectorConfiguration> configurations) {
        Iterator<CollectorConfiguration> cursor = configurations.iterator();
        if (cursor.hasNext()) {
            CollectorConfiguration result = cursor.next();
            result.tags().clear();
            while (cursor.hasNext()) {
                result.mergeWith(cursor.next());
            }
            return result;
        }
        return null;
    }

    public int deleteInput(String id, String inputId) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        List<CollectorInput> inputList = collectorConfiguration.inputs();
        int deleted = 0;
        if (inputList != null) {
            for (int i = 0; i < inputList.size(); ++i) {
                CollectorInput input = inputList.get(i);
                if (!input.inputId().equals(inputId)) continue;
                collectorConfiguration.inputs().remove(i);
                ++deleted;
            }
            this.save(collectorConfiguration);
        }
        return deleted;
    }

    public int deleteOutput(String id, String outputId) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        List<CollectorOutput> outputList = collectorConfiguration.outputs();
        List<CollectorInput> inputList = collectorConfiguration.inputs();
        if (inputList.stream().filter(input -> input.forwardTo().equals(outputId)).count() != 0L) {
            return -1;
        }
        int deleted = 0;
        if (outputList != null) {
            for (int i = 0; i < outputList.size(); ++i) {
                CollectorOutput output = outputList.get(i);
                if (!output.outputId().equals(outputId)) continue;
                collectorConfiguration.outputs().remove(i);
                ++deleted;
            }
            this.save(collectorConfiguration);
        }
        return deleted;
    }

    public int deleteSnippet(String id, String snippetId) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        List<CollectorConfigurationSnippet> snippetList = collectorConfiguration.snippets();
        int deleted = 0;
        if (snippetList != null) {
            for (int i = 0; i < snippetList.size(); ++i) {
                CollectorConfigurationSnippet snippet = snippetList.get(i);
                if (!snippet.snippetId().equals(snippetId)) continue;
                collectorConfiguration.snippets().remove(i);
                ++deleted;
            }
            this.save(collectorConfiguration);
        }
        return deleted;
    }

    public List<String> loadAllTags() {
        ArrayList<String> tags = new ArrayList<String>();
        DBCursor cursor = this.dbCollection.find();
        while (cursor.hasNext()) {
            CollectorConfiguration collectorConfiguration = (CollectorConfiguration)cursor.next();
            List newTags = collectorConfiguration.tags().stream().filter(t -> !tags.contains(t)).collect(Collectors.toList());
            tags.addAll(newTags);
        }
        return tags;
    }

    public CollectorConfiguration fromRequest(CollectorConfiguration request) {
        CollectorConfiguration collectorConfiguration = CollectorConfiguration.create(request.name(), request.tags(), request.inputs(), request.outputs(), request.snippets());
        return collectorConfiguration;
    }

    public CollectorConfiguration fromRequestWithDefaultSnippets(CollectorConfiguration request) {
        String nxlogDefaults;
        ArrayList<CollectorConfigurationSnippet> defaultSnippets = new ArrayList<CollectorConfigurationSnippet>();
        try {
            nxlogDefaults = IOUtils.toString((InputStream)this.classLoader.getResourceAsStream("snippets/defaults/nxlog.tmpl"));
        }
        catch (IOException e) {
            nxlogDefaults = "";
        }
        CollectorConfigurationSnippet nxlogSnippet = CollectorConfigurationSnippet.create("nxlog", "nxlog-defaults", nxlogDefaults);
        defaultSnippets.add(nxlogSnippet);
        return CollectorConfiguration.create(request.name(), request.tags(), request.inputs(), request.outputs(), defaultSnippets);
    }

    public CollectorConfiguration withInputFromRequest(String id, CollectorInput input) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        collectorConfiguration.inputs().add(input);
        return collectorConfiguration;
    }

    public CollectorConfiguration withOutputFromRequest(String id, CollectorOutput output) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        collectorConfiguration.outputs().add(output);
        return collectorConfiguration;
    }

    public CollectorConfiguration withSnippetFromRequest(String id, CollectorConfigurationSnippet snippet) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        collectorConfiguration.snippets().add(snippet);
        return collectorConfiguration;
    }

    public CollectorConfiguration withTagsFromRequest(String id, List<String> tags) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        collectorConfiguration.tags().clear();
        collectorConfiguration.tags().addAll(tags);
        return collectorConfiguration;
    }

    public CollectorConfiguration updateInputFromRequest(String id, String inputId, CollectorInput request) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        ListIterator<CollectorInput> inputIterator = collectorConfiguration.inputs().listIterator();
        while (inputIterator.hasNext()) {
            int i = inputIterator.nextIndex();
            CollectorInput input = inputIterator.next();
            if (!input.inputId().equals(inputId)) continue;
            collectorConfiguration.inputs().set(i, request);
        }
        return collectorConfiguration;
    }

    public CollectorConfiguration updateOutputFromRequest(String id, String outputId, CollectorOutput request) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        ListIterator<CollectorOutput> outputIterator = collectorConfiguration.outputs().listIterator();
        while (outputIterator.hasNext()) {
            int i = outputIterator.nextIndex();
            CollectorOutput output = outputIterator.next();
            if (!output.outputId().equals(outputId)) continue;
            collectorConfiguration.outputs().set(i, request);
        }
        return collectorConfiguration;
    }

    public CollectorConfiguration updateSnippetFromRequest(String id, String snippetId, CollectorConfigurationSnippet request) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        ListIterator<CollectorConfigurationSnippet> snippetIterator = collectorConfiguration.snippets().listIterator();
        while (snippetIterator.hasNext()) {
            int i = snippetIterator.nextIndex();
            CollectorConfigurationSnippet snippet = snippetIterator.next();
            if (!snippet.snippetId().equals(snippetId)) continue;
            collectorConfiguration.snippets().set(i, request);
        }
        return collectorConfiguration;
    }

    public CollectorConfiguration copyConfiguration(String id, String name) {
        CollectorConfiguration collectorConfigurationA = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        HashMap outputIdTranslation = new HashMap();
        ArrayList<CollectorOutput> outputList = new ArrayList<CollectorOutput>();
        ArrayList<CollectorInput> inputList = new ArrayList<CollectorInput>();
        ArrayList<CollectorConfigurationSnippet> snippetList = new ArrayList<CollectorConfigurationSnippet>();
        collectorConfigurationA.outputs().stream().forEach(output -> {
            CollectorOutput copiedOutput = CollectorOutput.create(output.backend(), output.type(), output.name(), output.properties());
            outputIdTranslation.put(output.outputId(), copiedOutput.outputId());
            outputList.add(copiedOutput);
        });
        collectorConfigurationA.inputs().stream().forEach(input -> inputList.add(CollectorInput.create(input.type(), input.backend(), input.name(), (String)outputIdTranslation.get(input.forwardTo()), input.properties())));
        collectorConfigurationA.snippets().stream().forEach(snippet -> snippetList.add(CollectorConfigurationSnippet.create(snippet.backend(), snippet.name(), snippet.snippet())));
        List<String> tags = Collections.emptyList();
        CollectorConfiguration collectorConfigurationB = CollectorConfiguration.create(name, tags, inputList, outputList, snippetList);
        return collectorConfigurationB;
    }

    public CollectorConfiguration copyOutput(String id, String outputId, String name) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        ArrayList outputList = new ArrayList();
        collectorConfiguration.outputs().stream().filter(output -> output.outputId().equals(outputId)).forEach(output -> outputList.add(CollectorOutput.create(output.backend(), output.type(), name, output.properties())));
        collectorConfiguration.outputs().addAll(outputList);
        return collectorConfiguration;
    }

    public CollectorConfiguration copyInput(String id, String inputId, String name) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        ArrayList inputList = new ArrayList();
        collectorConfiguration.inputs().stream().filter(input -> input.inputId().equals(inputId)).forEach(input -> inputList.add(CollectorInput.create(input.type(), input.backend(), name, input.forwardTo(), input.properties())));
        collectorConfiguration.inputs().addAll(inputList);
        return collectorConfiguration;
    }

    public CollectorConfiguration copySnippet(String id, String snippetId, String name) {
        CollectorConfiguration collectorConfiguration = (CollectorConfiguration)this.dbCollection.findOne(DBQuery.is((String)"_id", (Object)id));
        ArrayList snippetList = new ArrayList();
        collectorConfiguration.snippets().stream().filter(snippet -> snippet.snippetId().equals(snippetId)).forEach(snippet -> snippetList.add(CollectorConfigurationSnippet.create(snippet.backend(), name, snippet.snippet())));
        collectorConfiguration.snippets().addAll(snippetList);
        return collectorConfiguration;
    }
}

